/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.math.ec;

import java.math.BigInteger;
import org.csii.bouncycastle.math.ec.AbstractECMultiplier;
import org.csii.bouncycastle.math.ec.ECPoint;

public class ZSignedDigitL2RMultiplier
extends AbstractECMultiplier {
    protected ECPoint multiplyPositive(ECPoint p, BigInteger k) {
        ECPoint addP = p.normalize();
        ECPoint subP = addP.negate();
        ECPoint R0 = addP;
        int n = k.bitLength();
        int s = k.getLowestSetBit();
        int i = n;
        while (--i > s) {
            R0 = R0.twicePlus(k.testBit(i) ? addP : subP);
        }
        R0 = R0.timesPow2(s);
        return R0;
    }
}

