/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.ocsp;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.csii.bouncycastle.asn1.ASN1EncodableVector;
import org.csii.bouncycastle.asn1.ASN1GeneralizedTime;
import org.csii.bouncycastle.asn1.ASN1Primitive;
import org.csii.bouncycastle.asn1.ASN1Sequence;
import org.csii.bouncycastle.asn1.DERBitString;
import org.csii.bouncycastle.asn1.DERGeneralizedTime;
import org.csii.bouncycastle.asn1.DERNull;
import org.csii.bouncycastle.asn1.DERObjectIdentifier;
import org.csii.bouncycastle.asn1.DERSequence;
import org.csii.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.csii.bouncycastle.asn1.ocsp.CertStatus;
import org.csii.bouncycastle.asn1.ocsp.ResponseData;
import org.csii.bouncycastle.asn1.ocsp.RevokedInfo;
import org.csii.bouncycastle.asn1.ocsp.SingleResponse;
import org.csii.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.csii.bouncycastle.asn1.x509.CRLReason;
import org.csii.bouncycastle.asn1.x509.X509CertificateStructure;
import org.csii.bouncycastle.asn1.x509.X509Extensions;
import org.csii.bouncycastle.ocsp.BasicOCSPResp;
import org.csii.bouncycastle.ocsp.CertificateID;
import org.csii.bouncycastle.ocsp.CertificateStatus;
import org.csii.bouncycastle.ocsp.OCSPException;
import org.csii.bouncycastle.ocsp.OCSPUtil;
import org.csii.bouncycastle.ocsp.RespID;
import org.csii.bouncycastle.ocsp.RevokedStatus;
import org.csii.bouncycastle.ocsp.UnknownStatus;

public class BasicOCSPRespGenerator {
    private List list = new ArrayList();
    private X509Extensions responseExtensions = null;
    private RespID responderID;

    public BasicOCSPRespGenerator(RespID responderID) {
        this.responderID = responderID;
    }

    public BasicOCSPRespGenerator(PublicKey key) throws OCSPException {
        this.responderID = new RespID(key);
    }

    public void addResponse(CertificateID certID, CertificateStatus certStatus) {
        this.list.add(new ResponseObject(certID, certStatus, new Date(), null, null));
    }

    public void addResponse(CertificateID certID, CertificateStatus certStatus, X509Extensions singleExtensions) {
        this.list.add(new ResponseObject(certID, certStatus, new Date(), null, singleExtensions));
    }

    public void addResponse(CertificateID certID, CertificateStatus certStatus, Date nextUpdate, X509Extensions singleExtensions) {
        this.list.add(new ResponseObject(certID, certStatus, new Date(), nextUpdate, singleExtensions));
    }

    public void addResponse(CertificateID certID, CertificateStatus certStatus, Date thisUpdate, Date nextUpdate, X509Extensions singleExtensions) {
        this.list.add(new ResponseObject(certID, certStatus, thisUpdate, nextUpdate, singleExtensions));
    }

    public void setResponseExtensions(X509Extensions responseExtensions) {
        this.responseExtensions = responseExtensions;
    }

    private BasicOCSPResp generateResponse(String signatureName, PrivateKey key, X509Certificate[] chain, Date producedAt, String provider, SecureRandom random) throws OCSPException, NoSuchProviderException {
        DERObjectIdentifier signingAlgorithm;
        Iterator it = this.list.iterator();
        try {
            signingAlgorithm = OCSPUtil.getAlgorithmOID(signatureName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("unknown signing algorithm specified");
        }
        ASN1EncodableVector responses = new ASN1EncodableVector();
        while (it.hasNext()) {
            try {
                responses.add(((ResponseObject)it.next()).toResponse());
            }
            catch (Exception e) {
                throw new OCSPException("exception creating Request", e);
            }
        }
        ResponseData tbsResp = new ResponseData(this.responderID.toASN1Object(), new DERGeneralizedTime(producedAt), (ASN1Sequence)new DERSequence(responses), this.responseExtensions);
        Signature sig = null;
        try {
            sig = OCSPUtil.createSignatureInstance(signatureName, provider);
            if (random != null) {
                sig.initSign(key, random);
            } else {
                sig.initSign(key);
            }
        }
        catch (NoSuchProviderException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            throw new OCSPException("exception creating signature: " + e, e);
        }
        DERBitString bitSig = null;
        try {
            sig.update(tbsResp.getEncoded("DER"));
            bitSig = new DERBitString(sig.sign());
        }
        catch (Exception e) {
            throw new OCSPException("exception processing TBSRequest: " + e, e);
        }
        AlgorithmIdentifier sigAlgId = OCSPUtil.getSigAlgID(signingAlgorithm);
        DERSequence chainSeq = null;
        if (chain != null && chain.length > 0) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            try {
                int i = 0;
                while (i != chain.length) {
                    v.add(new X509CertificateStructure((ASN1Sequence)ASN1Primitive.fromByteArray(chain[i].getEncoded())));
                    ++i;
                }
            }
            catch (IOException e) {
                throw new OCSPException("error processing certs", e);
            }
            catch (CertificateEncodingException e) {
                throw new OCSPException("error encoding certs", e);
            }
            chainSeq = new DERSequence(v);
        }
        return new BasicOCSPResp(new BasicOCSPResponse(tbsResp, sigAlgId, bitSig, chainSeq));
    }

    public BasicOCSPResp generate(String signingAlgorithm, PrivateKey key, X509Certificate[] chain, Date thisUpdate, String provider) throws OCSPException, NoSuchProviderException, IllegalArgumentException {
        return this.generate(signingAlgorithm, key, chain, thisUpdate, provider, null);
    }

    public BasicOCSPResp generate(String signingAlgorithm, PrivateKey key, X509Certificate[] chain, Date producedAt, String provider, SecureRandom random) throws OCSPException, NoSuchProviderException, IllegalArgumentException {
        if (signingAlgorithm == null) {
            throw new IllegalArgumentException("no signing algorithm specified");
        }
        return this.generateResponse(signingAlgorithm, key, chain, producedAt, provider, random);
    }

    public Iterator getSignatureAlgNames() {
        return OCSPUtil.getAlgNames();
    }

    private class ResponseObject {
        CertificateID certId;
        CertStatus certStatus;
        DERGeneralizedTime thisUpdate;
        DERGeneralizedTime nextUpdate;
        X509Extensions extensions;

        public ResponseObject(CertificateID certId, CertificateStatus certStatus, Date thisUpdate, Date nextUpdate, X509Extensions extensions) {
            RevokedStatus rs;
            this.certId = certId;
            this.certStatus = certStatus == null ? new CertStatus() : (certStatus instanceof UnknownStatus ? new CertStatus(2, DERNull.INSTANCE) : ((rs = (RevokedStatus)certStatus).hasRevocationReason() ? new CertStatus(new RevokedInfo(new ASN1GeneralizedTime(rs.getRevocationTime()), CRLReason.lookup(rs.getRevocationReason()))) : new CertStatus(new RevokedInfo(new ASN1GeneralizedTime(rs.getRevocationTime()), null))));
            this.thisUpdate = new DERGeneralizedTime(thisUpdate);
            this.nextUpdate = nextUpdate != null ? new DERGeneralizedTime(nextUpdate) : null;
            this.extensions = extensions;
        }

        public SingleResponse toResponse() throws Exception {
            return new SingleResponse(this.certId.toASN1Object(), this.certStatus, this.thisUpdate, this.nextUpdate, this.extensions);
        }
    }
}

