/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.pqc.crypto.mceliece;

import java.security.SecureRandom;
import org.csii.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.csii.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.csii.bouncycastle.crypto.KeyGenerationParameters;
import org.csii.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyGenerationParameters;
import org.csii.bouncycastle.pqc.crypto.mceliece.McElieceCCA2Parameters;
import org.csii.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import org.csii.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import org.csii.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import org.csii.bouncycastle.pqc.math.linearalgebra.GF2mField;
import org.csii.bouncycastle.pqc.math.linearalgebra.GoppaCode;
import org.csii.bouncycastle.pqc.math.linearalgebra.Permutation;
import org.csii.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import org.csii.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2m;

public class McElieceCCA2KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.2";
    private McElieceCCA2KeyGenerationParameters mcElieceCCA2Params;
    private int m;
    private int n;
    private int t;
    private int fieldPoly;
    private SecureRandom random;
    private boolean initialized = false;

    private void initializeDefault() {
        McElieceCCA2KeyGenerationParameters mcCCA2Params = new McElieceCCA2KeyGenerationParameters(new SecureRandom(), new McElieceCCA2Parameters());
        this.init(mcCCA2Params);
    }

    public void init(KeyGenerationParameters param) {
        this.mcElieceCCA2Params = (McElieceCCA2KeyGenerationParameters)param;
        this.random = new SecureRandom();
        this.m = this.mcElieceCCA2Params.getParameters().getM();
        this.n = this.mcElieceCCA2Params.getParameters().getN();
        this.t = this.mcElieceCCA2Params.getParameters().getT();
        this.fieldPoly = this.mcElieceCCA2Params.getParameters().getFieldPoly();
        this.initialized = true;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        if (!this.initialized) {
            this.initializeDefault();
        }
        GF2mField field = new GF2mField(this.m, this.fieldPoly);
        PolynomialGF2mSmallM gp = new PolynomialGF2mSmallM(field, this.t, 'I', this.random);
        PolynomialRingGF2m ring = new PolynomialRingGF2m(field, gp);
        PolynomialGF2mSmallM[] qInv = ring.getSquareRootMatrix();
        GF2Matrix h = GoppaCode.createCanonicalCheckMatrix(field, gp);
        GoppaCode.MaMaPe mmp = GoppaCode.computeSystematicForm(h, this.random);
        GF2Matrix shortH = mmp.getSecondMatrix();
        Permutation p = mmp.getPermutation();
        GF2Matrix shortG = (GF2Matrix)shortH.computeTranspose();
        int k = shortG.getNumRows();
        McElieceCCA2PublicKeyParameters pubKey = new McElieceCCA2PublicKeyParameters(OID, this.n, this.t, shortG, this.mcElieceCCA2Params.getParameters());
        McElieceCCA2PrivateKeyParameters privKey = new McElieceCCA2PrivateKeyParameters(OID, this.n, k, field, gp, p, h, qInv, this.mcElieceCCA2Params.getParameters());
        return new AsymmetricCipherKeyPair(pubKey, privKey);
    }
}

