/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.pqc.crypto.rainbow;

import java.security.SecureRandom;
import org.csii.bouncycastle.pqc.crypto.rainbow.util.GF2Field;
import org.csii.bouncycastle.pqc.crypto.rainbow.util.RainbowUtil;
import org.csii.bouncycastle.util.Arrays;

public class Layer {
    private int vi;
    private int viNext;
    private int oi;
    private short[][][] coeff_alpha;
    private short[][][] coeff_beta;
    private short[][] coeff_gamma;
    private short[] coeff_eta;

    public Layer(byte vi, byte viNext, short[][][] coeffAlpha, short[][][] coeffBeta, short[][] coeffGamma, short[] coeffEta) {
        this.vi = vi & 0xFF;
        this.viNext = viNext & 0xFF;
        this.oi = this.viNext - this.vi;
        this.coeff_alpha = coeffAlpha;
        this.coeff_beta = coeffBeta;
        this.coeff_gamma = coeffGamma;
        this.coeff_eta = coeffEta;
    }

    public Layer(int vi, int viNext, SecureRandom sr) {
        int j;
        int i;
        this.vi = vi;
        this.viNext = viNext;
        this.oi = viNext - vi;
        this.coeff_alpha = new short[this.oi][this.oi][this.vi];
        this.coeff_beta = new short[this.oi][this.vi][this.vi];
        this.coeff_gamma = new short[this.oi][this.viNext];
        this.coeff_eta = new short[this.oi];
        int numOfPoly = this.oi;
        int k = 0;
        while (k < numOfPoly) {
            i = 0;
            while (i < this.oi) {
                j = 0;
                while (j < this.vi) {
                    this.coeff_alpha[k][i][j] = (short)(sr.nextInt() & 0xFF);
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        k = 0;
        while (k < numOfPoly) {
            i = 0;
            while (i < this.vi) {
                j = 0;
                while (j < this.vi) {
                    this.coeff_beta[k][i][j] = (short)(sr.nextInt() & 0xFF);
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        k = 0;
        while (k < numOfPoly) {
            i = 0;
            while (i < this.viNext) {
                this.coeff_gamma[k][i] = (short)(sr.nextInt() & 0xFF);
                ++i;
            }
            ++k;
        }
        k = 0;
        while (k < numOfPoly) {
            this.coeff_eta[k] = (short)(sr.nextInt() & 0xFF);
            ++k;
        }
    }

    public short[][] plugInVinegars(short[] x) {
        int j;
        int i;
        short tmpMult = 0;
        short[][] coeff = new short[this.oi][this.oi + 1];
        short[] sum = new short[this.oi];
        int k = 0;
        while (k < this.oi) {
            i = 0;
            while (i < this.vi) {
                j = 0;
                while (j < this.vi) {
                    tmpMult = GF2Field.multElem(this.coeff_beta[k][i][j], x[i]);
                    tmpMult = GF2Field.multElem(tmpMult, x[j]);
                    sum[k] = GF2Field.addElem(sum[k], tmpMult);
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        k = 0;
        while (k < this.oi) {
            i = 0;
            while (i < this.oi) {
                j = 0;
                while (j < this.vi) {
                    tmpMult = GF2Field.multElem(this.coeff_alpha[k][i][j], x[j]);
                    coeff[k][i] = GF2Field.addElem(coeff[k][i], tmpMult);
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        k = 0;
        while (k < this.oi) {
            i = 0;
            while (i < this.vi) {
                tmpMult = GF2Field.multElem(this.coeff_gamma[k][i], x[i]);
                sum[k] = GF2Field.addElem(sum[k], tmpMult);
                ++i;
            }
            ++k;
        }
        k = 0;
        while (k < this.oi) {
            i = this.vi;
            while (i < this.viNext) {
                coeff[k][i - this.vi] = GF2Field.addElem(this.coeff_gamma[k][i], coeff[k][i - this.vi]);
                ++i;
            }
            ++k;
        }
        k = 0;
        while (k < this.oi) {
            sum[k] = GF2Field.addElem(sum[k], this.coeff_eta[k]);
            ++k;
        }
        k = 0;
        while (k < this.oi) {
            coeff[k][this.oi] = sum[k];
            ++k;
        }
        return coeff;
    }

    public int getVi() {
        return this.vi;
    }

    public int getViNext() {
        return this.viNext;
    }

    public int getOi() {
        return this.oi;
    }

    public short[][][] getCoeffAlpha() {
        return this.coeff_alpha;
    }

    public short[][][] getCoeffBeta() {
        return this.coeff_beta;
    }

    public short[][] getCoeffGamma() {
        return this.coeff_gamma;
    }

    public short[] getCoeffEta() {
        return this.coeff_eta;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Layer)) {
            return false;
        }
        Layer otherLayer = (Layer)other;
        return this.vi == otherLayer.getVi() && this.viNext == otherLayer.getViNext() && this.oi == otherLayer.getOi() && RainbowUtil.equals(this.coeff_alpha, otherLayer.getCoeffAlpha()) && RainbowUtil.equals(this.coeff_beta, otherLayer.getCoeffBeta()) && RainbowUtil.equals(this.coeff_gamma, otherLayer.getCoeffGamma()) && RainbowUtil.equals(this.coeff_eta, otherLayer.getCoeffEta());
    }

    public int hashCode() {
        int hash = this.vi;
        hash = hash * 37 + this.viNext;
        hash = hash * 37 + this.oi;
        hash = hash * 37 + Arrays.hashCode(this.coeff_alpha);
        hash = hash * 37 + Arrays.hashCode(this.coeff_beta);
        hash = hash * 37 + Arrays.hashCode(this.coeff_gamma);
        hash = hash * 37 + Arrays.hashCode(this.coeff_eta);
        return hash;
    }
}

