/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.pqc.crypto.rainbow;

import java.security.SecureRandom;
import org.csii.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.csii.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.csii.bouncycastle.crypto.KeyGenerationParameters;
import org.csii.bouncycastle.pqc.crypto.rainbow.Layer;
import org.csii.bouncycastle.pqc.crypto.rainbow.RainbowKeyGenerationParameters;
import org.csii.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import org.csii.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import org.csii.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import org.csii.bouncycastle.pqc.crypto.rainbow.util.ComputeInField;
import org.csii.bouncycastle.pqc.crypto.rainbow.util.GF2Field;

public class RainbowKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private boolean initialized = false;
    private SecureRandom sr;
    private RainbowKeyGenerationParameters rainbowParams;
    private short[][] A1;
    private short[][] A1inv;
    private short[] b1;
    private short[][] A2;
    private short[][] A2inv;
    private short[] b2;
    private int numOfLayers;
    private Layer[] layers;
    private int[] vi;
    private short[][] pub_quadratic;
    private short[][] pub_singular;
    private short[] pub_scalar;

    public AsymmetricCipherKeyPair genKeyPair() {
        if (!this.initialized) {
            this.initializeDefault();
        }
        this.keygen();
        RainbowPrivateKeyParameters privKey = new RainbowPrivateKeyParameters(this.A1inv, this.b1, this.A2inv, this.b2, this.vi, this.layers);
        RainbowPublicKeyParameters pubKey = new RainbowPublicKeyParameters(this.vi[this.vi.length - 1] - this.vi[0], this.pub_quadratic, this.pub_singular, this.pub_scalar);
        return new AsymmetricCipherKeyPair(pubKey, privKey);
    }

    public void initialize(KeyGenerationParameters param) {
        this.rainbowParams = (RainbowKeyGenerationParameters)param;
        this.sr = new SecureRandom();
        this.vi = this.rainbowParams.getParameters().getVi();
        this.numOfLayers = this.rainbowParams.getParameters().getNumOfLayers();
        this.initialized = true;
    }

    private void initializeDefault() {
        RainbowKeyGenerationParameters rbKGParams = new RainbowKeyGenerationParameters(new SecureRandom(), new RainbowParameters());
        this.initialize(rbKGParams);
    }

    private void keygen() {
        this.generateL1();
        this.generateL2();
        this.generateF();
        this.computePublicKey();
    }

    private void generateL1() {
        int i;
        int dim = this.vi[this.vi.length - 1] - this.vi[0];
        this.A1 = new short[dim][dim];
        this.A1inv = null;
        ComputeInField c = new ComputeInField();
        while (this.A1inv == null) {
            i = 0;
            while (i < dim) {
                int j = 0;
                while (j < dim) {
                    this.A1[i][j] = (short)(this.sr.nextInt() & 0xFF);
                    ++j;
                }
                ++i;
            }
            this.A1inv = c.inverse(this.A1);
        }
        this.b1 = new short[dim];
        i = 0;
        while (i < dim) {
            this.b1[i] = (short)(this.sr.nextInt() & 0xFF);
            ++i;
        }
    }

    private void generateL2() {
        int i;
        int dim = this.vi[this.vi.length - 1];
        this.A2 = new short[dim][dim];
        this.A2inv = null;
        ComputeInField c = new ComputeInField();
        while (this.A2inv == null) {
            i = 0;
            while (i < dim) {
                int j = 0;
                while (j < dim) {
                    this.A2[i][j] = (short)(this.sr.nextInt() & 0xFF);
                    ++j;
                }
                ++i;
            }
            this.A2inv = c.inverse(this.A2);
        }
        this.b2 = new short[dim];
        i = 0;
        while (i < dim) {
            this.b2[i] = (short)(this.sr.nextInt() & 0xFF);
            ++i;
        }
    }

    private void generateF() {
        this.layers = new Layer[this.numOfLayers];
        int i = 0;
        while (i < this.numOfLayers) {
            this.layers[i] = new Layer(this.vi[i], this.vi[i + 1], this.sr);
            ++i;
        }
    }

    private void computePublicKey() {
        ComputeInField c = new ComputeInField();
        int rows = this.vi[this.vi.length - 1] - this.vi[0];
        int vars = this.vi[this.vi.length - 1];
        short[][][] coeff_quadratic_3dim = new short[rows][vars][vars];
        this.pub_singular = new short[rows][vars];
        this.pub_scalar = new short[rows];
        int oils = 0;
        int vins = 0;
        int crnt_row = 0;
        short[] vect_tmp = new short[vars];
        short sclr_tmp = 0;
        int l = 0;
        while (l < this.layers.length) {
            short[][][] coeff_alpha = this.layers[l].getCoeffAlpha();
            short[][][] coeff_beta = this.layers[l].getCoeffBeta();
            short[][] coeff_gamma = this.layers[l].getCoeffGamma();
            short[] coeff_eta = this.layers[l].getCoeffEta();
            oils = coeff_alpha[0].length;
            vins = coeff_beta[0].length;
            int p = 0;
            while (p < oils) {
                int x2;
                int x1 = 0;
                while (x1 < oils) {
                    x2 = 0;
                    while (x2 < vins) {
                        vect_tmp = c.multVect(coeff_alpha[p][x1][x2], this.A2[x1 + vins]);
                        coeff_quadratic_3dim[crnt_row + p] = c.addSquareMatrix(coeff_quadratic_3dim[crnt_row + p], c.multVects(vect_tmp, this.A2[x2]));
                        vect_tmp = c.multVect(this.b2[x2], vect_tmp);
                        this.pub_singular[crnt_row + p] = c.addVect(vect_tmp, this.pub_singular[crnt_row + p]);
                        vect_tmp = c.multVect(coeff_alpha[p][x1][x2], this.A2[x2]);
                        vect_tmp = c.multVect(this.b2[x1 + vins], vect_tmp);
                        this.pub_singular[crnt_row + p] = c.addVect(vect_tmp, this.pub_singular[crnt_row + p]);
                        sclr_tmp = GF2Field.multElem(coeff_alpha[p][x1][x2], this.b2[x1 + vins]);
                        this.pub_scalar[crnt_row + p] = GF2Field.addElem(this.pub_scalar[crnt_row + p], GF2Field.multElem(sclr_tmp, this.b2[x2]));
                        ++x2;
                    }
                    ++x1;
                }
                x1 = 0;
                while (x1 < vins) {
                    x2 = 0;
                    while (x2 < vins) {
                        vect_tmp = c.multVect(coeff_beta[p][x1][x2], this.A2[x1]);
                        coeff_quadratic_3dim[crnt_row + p] = c.addSquareMatrix(coeff_quadratic_3dim[crnt_row + p], c.multVects(vect_tmp, this.A2[x2]));
                        vect_tmp = c.multVect(this.b2[x2], vect_tmp);
                        this.pub_singular[crnt_row + p] = c.addVect(vect_tmp, this.pub_singular[crnt_row + p]);
                        vect_tmp = c.multVect(coeff_beta[p][x1][x2], this.A2[x2]);
                        vect_tmp = c.multVect(this.b2[x1], vect_tmp);
                        this.pub_singular[crnt_row + p] = c.addVect(vect_tmp, this.pub_singular[crnt_row + p]);
                        sclr_tmp = GF2Field.multElem(coeff_beta[p][x1][x2], this.b2[x1]);
                        this.pub_scalar[crnt_row + p] = GF2Field.addElem(this.pub_scalar[crnt_row + p], GF2Field.multElem(sclr_tmp, this.b2[x2]));
                        ++x2;
                    }
                    ++x1;
                }
                int n = 0;
                while (n < vins + oils) {
                    vect_tmp = c.multVect(coeff_gamma[p][n], this.A2[n]);
                    this.pub_singular[crnt_row + p] = c.addVect(vect_tmp, this.pub_singular[crnt_row + p]);
                    this.pub_scalar[crnt_row + p] = GF2Field.addElem(this.pub_scalar[crnt_row + p], GF2Field.multElem(coeff_gamma[p][n], this.b2[n]));
                    ++n;
                }
                this.pub_scalar[crnt_row + p] = GF2Field.addElem(this.pub_scalar[crnt_row + p], coeff_eta[p]);
                ++p;
            }
            crnt_row += oils;
            ++l;
        }
        short[][][] tmp_c_quad = new short[rows][vars][vars];
        short[][] tmp_c_sing = new short[rows][vars];
        short[] tmp_c_scal = new short[rows];
        int r = 0;
        while (r < rows) {
            int q = 0;
            while (q < this.A1.length) {
                tmp_c_quad[r] = c.addSquareMatrix(tmp_c_quad[r], c.multMatrix(this.A1[r][q], coeff_quadratic_3dim[q]));
                tmp_c_sing[r] = c.addVect(tmp_c_sing[r], c.multVect(this.A1[r][q], this.pub_singular[q]));
                tmp_c_scal[r] = GF2Field.addElem(tmp_c_scal[r], GF2Field.multElem(this.A1[r][q], this.pub_scalar[q]));
                ++q;
            }
            tmp_c_scal[r] = GF2Field.addElem(tmp_c_scal[r], this.b1[r]);
            ++r;
        }
        coeff_quadratic_3dim = tmp_c_quad;
        this.pub_singular = tmp_c_sing;
        this.pub_scalar = tmp_c_scal;
        this.compactPublicKey(coeff_quadratic_3dim);
    }

    private void compactPublicKey(short[][][] coeff_quadratic_to_compact) {
        int polynomials = coeff_quadratic_to_compact.length;
        int n = coeff_quadratic_to_compact[0].length;
        int entries = n * (n + 1) / 2;
        this.pub_quadratic = new short[polynomials][entries];
        int offset = 0;
        int p = 0;
        while (p < polynomials) {
            offset = 0;
            int x = 0;
            while (x < n) {
                int y = x;
                while (y < n) {
                    this.pub_quadratic[p][offset] = y == x ? coeff_quadratic_to_compact[p][x][y] : GF2Field.addElem(coeff_quadratic_to_compact[p][x][y], coeff_quadratic_to_compact[p][y][x]);
                    ++offset;
                    ++y;
                }
                ++x;
            }
            ++p;
        }
    }

    public void init(KeyGenerationParameters param) {
        this.initialize(param);
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

