/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.x509;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.csii.bouncycastle.asn1.ASN1Encodable;
import org.csii.bouncycastle.asn1.ASN1EncodableVector;
import org.csii.bouncycastle.asn1.ASN1GeneralizedTime;
import org.csii.bouncycastle.asn1.ASN1InputStream;
import org.csii.bouncycastle.asn1.ASN1Integer;
import org.csii.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.csii.bouncycastle.asn1.ASN1Sequence;
import org.csii.bouncycastle.asn1.DERBitString;
import org.csii.bouncycastle.asn1.DERObjectIdentifier;
import org.csii.bouncycastle.asn1.DERSequence;
import org.csii.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.csii.bouncycastle.asn1.x509.CertificateList;
import org.csii.bouncycastle.asn1.x509.Extensions;
import org.csii.bouncycastle.asn1.x509.TBSCertList;
import org.csii.bouncycastle.asn1.x509.Time;
import org.csii.bouncycastle.asn1.x509.V2TBSCertListGenerator;
import org.csii.bouncycastle.asn1.x509.X509Extensions;
import org.csii.bouncycastle.asn1.x509.X509ExtensionsGenerator;
import org.csii.bouncycastle.asn1.x509.X509Name;
import org.csii.bouncycastle.jce.X509Principal;
import org.csii.bouncycastle.jce.provider.X509CRLObject;
import org.csii.bouncycastle.x509.X509Util;

public class X509V2CRLGenerator {
    private V2TBSCertListGenerator tbsGen = new V2TBSCertListGenerator();
    private DERObjectIdentifier sigOID;
    private AlgorithmIdentifier sigAlgId;
    private String signatureAlgorithm;
    private X509ExtensionsGenerator extGenerator = new X509ExtensionsGenerator();

    public void reset() {
        this.tbsGen = new V2TBSCertListGenerator();
        this.extGenerator.reset();
    }

    public void setIssuerDN(X500Principal issuer) {
        try {
            this.tbsGen.setIssuer(new X509Principal(issuer.getEncoded()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can't process principal: " + e);
        }
    }

    public void setIssuerDN(X509Name issuer) {
        this.tbsGen.setIssuer(issuer);
    }

    public void setThisUpdate(Date date) {
        this.tbsGen.setThisUpdate(new Time(date));
    }

    public void setNextUpdate(Date date) {
        this.tbsGen.setNextUpdate(new Time(date));
    }

    public void addCRLEntry(BigInteger userCertificate, Date revocationDate, int reason) {
        this.tbsGen.addCRLEntry(new ASN1Integer(userCertificate), new Time(revocationDate), reason);
    }

    public void addCRLEntry(BigInteger userCertificate, Date revocationDate, int reason, Date invalidityDate) {
        this.tbsGen.addCRLEntry(new ASN1Integer(userCertificate), new Time(revocationDate), reason, new ASN1GeneralizedTime(invalidityDate));
    }

    public void addCRLEntry(BigInteger userCertificate, Date revocationDate, X509Extensions extensions) {
        this.tbsGen.addCRLEntry(new ASN1Integer(userCertificate), new Time(revocationDate), Extensions.getInstance(extensions));
    }

    public void addCRL(X509CRL other) throws CRLException {
        Set<? extends X509CRLEntry> revocations = other.getRevokedCertificates();
        if (revocations != null) {
            Iterator<? extends X509CRLEntry> it = revocations.iterator();
            while (it.hasNext()) {
                X509CRLEntry entry = it.next();
                ASN1InputStream aIn = new ASN1InputStream(entry.getEncoded());
                try {
                    this.tbsGen.addCRLEntry(ASN1Sequence.getInstance(aIn.readObject()));
                }
                catch (IOException e) {
                    throw new CRLException("exception processing encoding of CRL: " + e.toString());
                }
            }
        }
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        try {
            this.sigOID = X509Util.getAlgorithmOID(signatureAlgorithm);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown signature type requested");
        }
        this.sigAlgId = X509Util.getSigAlgID(this.sigOID, signatureAlgorithm);
        this.tbsGen.setSignature(this.sigAlgId);
    }

    public void addExtension(String oid, boolean critical, ASN1Encodable value) {
        this.addExtension(new DERObjectIdentifier(oid), critical, value);
    }

    public void addExtension(DERObjectIdentifier oid, boolean critical, ASN1Encodable value) {
        this.extGenerator.addExtension(new ASN1ObjectIdentifier(oid.getId()), critical, value);
    }

    public void addExtension(String oid, boolean critical, byte[] value) {
        this.addExtension(new DERObjectIdentifier(oid), critical, value);
    }

    public void addExtension(DERObjectIdentifier oid, boolean critical, byte[] value) {
        this.extGenerator.addExtension(new ASN1ObjectIdentifier(oid.getId()), critical, value);
    }

    public X509CRL generateX509CRL(PrivateKey key) throws SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generateX509CRL(key, "BC", null);
        }
        catch (NoSuchProviderException e) {
            throw new SecurityException("BC provider not installed!");
        }
    }

    public X509CRL generateX509CRL(PrivateKey key, SecureRandom random) throws SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generateX509CRL(key, "BC", random);
        }
        catch (NoSuchProviderException e) {
            throw new SecurityException("BC provider not installed!");
        }
    }

    public X509CRL generateX509CRL(PrivateKey key, String provider) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        return this.generateX509CRL(key, provider, null);
    }

    public X509CRL generateX509CRL(PrivateKey key, String provider, SecureRandom random) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generate(key, provider, random);
        }
        catch (NoSuchProviderException e) {
            throw e;
        }
        catch (SignatureException e) {
            throw e;
        }
        catch (InvalidKeyException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            throw new SecurityException("exception: " + e);
        }
    }

    public X509CRL generate(PrivateKey key) throws CRLException, IllegalStateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        return this.generate(key, (SecureRandom)null);
    }

    public X509CRL generate(PrivateKey key, SecureRandom random) throws CRLException, IllegalStateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        byte[] signature;
        TBSCertList tbsCrl = this.generateCertList();
        try {
            signature = X509Util.calculateSignature(this.sigOID, this.signatureAlgorithm, key, random, tbsCrl);
        }
        catch (IOException e) {
            throw new ExtCRLException("cannot generate CRL encoding", e);
        }
        return this.generateJcaObject(tbsCrl, signature);
    }

    public X509CRL generate(PrivateKey key, String provider) throws CRLException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        return this.generate(key, provider, null);
    }

    public X509CRL generate(PrivateKey key, String provider, SecureRandom random) throws CRLException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        byte[] signature;
        TBSCertList tbsCrl = this.generateCertList();
        try {
            signature = X509Util.calculateSignature(this.sigOID, this.signatureAlgorithm, provider, key, random, tbsCrl);
        }
        catch (IOException e) {
            throw new ExtCRLException("cannot generate CRL encoding", e);
        }
        return this.generateJcaObject(tbsCrl, signature);
    }

    private TBSCertList generateCertList() {
        if (!this.extGenerator.isEmpty()) {
            this.tbsGen.setExtensions(this.extGenerator.generate());
        }
        return this.tbsGen.generateTBSCertList();
    }

    private X509CRL generateJcaObject(TBSCertList tbsCrl, byte[] signature) throws CRLException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(tbsCrl);
        v.add(this.sigAlgId);
        v.add(new DERBitString(signature));
        return new X509CRLObject(new CertificateList(new DERSequence(v)));
    }

    public Iterator getSignatureAlgNames() {
        return X509Util.getAlgNames();
    }

    private static class ExtCRLException
    extends CRLException {
        Throwable cause;

        ExtCRLException(String message, Throwable cause) {
            super(message);
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }
    }
}

