package cn.com.duiba.activity.center.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 插件活动用户领奖验证的验证策略
 * Created by sty on 12/18/17.
 */
public enum PluginJoinVerificyModeEnum {

    NGAMEMUTIRANK(1,"多游戏排行榜验证"),
    OPTIONNUMRANK(2,"奖项数量排行榜验证"),
    UNLOCKINGRECORD(3, "解锁记录验证");

    private Integer code;
    private String desc;

    private static Map<Integer,PluginJoinVerificyModeEnum> typeMap = new HashMap<>();
    static{
        for(PluginJoinVerificyModeEnum typeEnum:values()){
            typeMap.put(typeEnum.getCode(),typeEnum);
        }
    }

    PluginJoinVerificyModeEnum(Integer code,String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * 根据code获取类型，获取失败则抛出异常
     * @param code
     * @return
     */
    public static PluginJoinVerificyModeEnum getVerificyModeByCode(Integer code){
        return typeMap.get(code);
    }


    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

}

