/**
 * Project Name:activity-center-api
 * File Name:PushStatusEnum.java
 * Package Name:cn.com.duiba.activity.center.api.enums
 * Date:2016年9月30日下午2:56:36
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * 推送任务状态
 * Date:     2016年9月30日 下午2:56:36 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public enum PushStatusEnum implements EnumInterface {
    /** 任务执行中 */
    EXEC("EXEC", "执行中"),

    /** 任务成功 */
    SUCC("SUCC", "成功"),
    
    /** 任务失败 */
    FAILED("FAILED", "失败");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private PushStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param code
     * @return
     * @since JDK 1.6
     */
    public static PushStatusEnum getByCode(String code) {
        for (PushStatusEnum enumVal : PushStatusEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDesc() {
        return desc;
    }
}

