package cn.com.duiba.activity.center.api.remoteservice.activity_brick;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.activity_brick.PopupActivityBrickDto;
import cn.com.duiba.activity.center.api.dto.activity_brick.PopupActivityBrickSimpleDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 
 * ClassName: RemotePopupActivityBrickBackendService <br/>
 * date: 2016年12月1日 下午1:47:10 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemotePopupActivityBrickBackendService {
    /**
     * 
     * insert:(这里用一句话描述这个方法的作用). <br/>
     * 插入签到皮肤
     * @param brick
     * @return
     * @since JDK 1.6
     */
	DubboResult<PopupActivityBrickDto> insert(PopupActivityBrickDto brick);

	/**
	 * 
	 * update:(这里用一句话描述这个方法的作用). <br/>
	 * 编辑签到皮肤
	 * @param brick
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Integer> update(PopupActivityBrickDto brick);

	/**
	 * 
	 * findById:(这里用一句话描述这个方法的作用). <br/>
	 * 根据Id查询签到皮肤
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<PopupActivityBrickDto> findById(Long id);

	/**
	 * 
	 * deleteById:(这里用一句话描述这个方法的作用). <br/>
	 * 删除签到皮肤
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Integer> deleteById(Long id);

	/**
	 * 
	 * showBrick:(这里用一句话描述这个方法的作用). <br/>
	 * 展示签到皮肤
	 * @author liyang
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Integer> showBrick(Long id);

	/**
	 * 
	 * hiddenBrick:(这里用一句话描述这个方法的作用). <br/>
	 * 隐藏签到皮肤
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Integer> hiddenBrick(Long id);
	
	/**
	 * 
	 * findPage:(这里用一句话描述这个方法的作用). <br/>
	 * 查询皮肤list
	 * @param type
	 * @param offset
	 * @param max
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<List<PopupActivityBrickDto>> findPage(Integer type, Integer offset, Integer max);
	
	/**
	 * 
	 * findPageCount:(这里用一句话描述这个方法的作用). <br/>
	 * 查询皮肤满足条件的总条数
	 * @param type
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Long> findPageCount(Integer type);
	
	/**
	 * 
	 * findAll:(这里用一句话描述这个方法的作用). <br/>
	 * 查询皮肤list
	 * @param type
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<List<PopupActivityBrickDto>> findAll(Integer type);
	
	/**
	 * 
	 * findByName:(这里用一句话描述这个方法的作用). <br/>
	 * 根据Name查询签到皮肤
	 * @param type
	 * @param name
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<PopupActivityBrickDto> findByName(Integer type, String name);
	
	/**
	 * 
	 * findByCondition:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param appId
	 * @param name
	 * @param offset
	 * @param max
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<List<PopupActivityBrickDto>> findByCondition(Long appId, String name, Integer offset, Integer max);

	/**
	 * 
	 * findByConditionCount:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param appId
	 * @param name
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Long> findByConditionCount(Long appId, String name);
	
	/**
	 * 
	 * updateLayoutBrickPosition:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param position
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Integer> updateLayoutBrickPosition(Long id, Integer position);
	
	/**
	 * 
	 * findSysSign:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<PopupActivityBrickDto> findSysSign();

	/**
	 * 根据ID批量查询
	 * @param ids
	 * @return
	 */
	List<PopupActivityBrickSimpleDto> batchFindByTypeAndIds(Integer type, List<Long> ids);

	/**
	 *
	 * findSysSignNew:(查询签到皮肤). <br/>
	 *  产品约定 默认签到皮肤有2款 1款 750  1款 640
	 *
	 * @return
	 * @since JDK 1.6
	 */
	List<PopupActivityBrickDto> findSysSignList();
}
