package cn.com.duiba.activity.center.api.remoteservice.sign;

import cn.com.duiba.activity.center.api.dto.sign.SignInfoDto;
import cn.com.duiba.activity.center.api.dto.sign.SignStaticsDto;
import cn.com.duiba.activity.center.api.enums.SignSourceTypeEnum;
import cn.com.duiba.activity.center.api.params.SignInfoQueryParam;
import cn.com.duiba.activity.center.api.params.SignStaticsQueryParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 签到统计信息
 * Created by xiaoxuda on 2017/5/31.
 */
@AdvancedFeignClient
public interface RemoteSignStaticsService {
    /**
     * 根据用户ID、签到数据来源、来源关联ID查询签到统计信息
     * @param consumerId
     * @param sourceType NOT NULL
     * @param sourceRelationId 非必填
     * @return
     */
    @Deprecated
    DubboResult<SignStaticsDto> findByConsumerIdAndSourceTypeAndRelationId(long consumerId,
                                                                           SignSourceTypeEnum sourceType,
                                                                          Long sourceRelationId);
    /**
     * 根据用户ID、签到数据来源、来源关联ID查询签到统计信息
     * @param param
     * @return
     */
    SignStaticsDto findSignStaticsByUK(SignStaticsQueryParam param);


    /**
     * 获取用户当前签到信息
     * @param param
     * @return
     */
    SignInfoDto getSignInfoByConsumer(SignInfoQueryParam param);
}
