package cn.com.duiba.activity.center.api.remoteservice.newgamecenter;

import cn.com.duiba.activity.center.api.dto.newgamecenter.NewGameCenterConfigDto;
import cn.com.duiba.activity.center.api.dto.newgamecenter.NewGameCenterConfigInsertParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 积分商城新游戏中心管理后台配置服务
 * @author zhangruofan
 * @date 2018/09/03
 */
@AdvancedFeignClient
public interface RemoteNewGameCenterBackendService {
    /**
     * 新增游戏中心配置和第一个赛季
     * @param param param
     * @return id
     */
    Long insert(NewGameCenterConfigInsertParam param);

    /**
     * 分页获取游戏中心配置
     * @param pageNo 页码
     * @param pageSize 页面大小
     * @return Page<NewGameCenterConfigDto>
     */
    @Deprecated
    cn.com.duiba.biz.tool.duiba.dto.page.Page<NewGameCenterConfigDto> list(Integer pageNo, Integer pageSize);

    /**
     * 分页获取游戏中心配置
     * @param pageNo 页码
     * @param pageSize 页面大小
     * @return Page<NewGameCenterConfigDto>
     */
    Page<NewGameCenterConfigDto> listApi(Integer pageNo, Integer pageSize);

    /**
     * 更新游戏中心状态
     * @param configStatus 游戏中心状态
     * @param id id
     * @return 影响行数
     */
    Integer update(Integer configStatus, Long id);

}
