package cn.com.duiba.activity.center.api.remoteservice.seedredpacket;

import cn.com.duiba.activity.center.api.dto.seedredpacket.SeedRedPacketDto;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.api.bo.page.PageQuery;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author zhengjianhao
 * @date 18/7/5
 * @description
 */
@AdvancedFeignClient
public interface RemoteBackendSeedRedPacketService {

    /**
     * 新增
     */
    long insert(SeedRedPacketDto config) throws BizException;

    /**
     * 更新
     */
    boolean updateGeneral(SeedRedPacketDto config);

    /**
     * 删除
     */
    int deleted(Long id);

    /**
     * 更新
     */
    boolean updateGeneralExtra(SeedRedPacketDto config, Long consumerId, Long appId);

    /**
     * 删除
     */
    int deletedExtra(Long id, Long consumerId, Long appId);

    /**
     * 状态变更
     */
    int updateStatus(Long id, Integer status);

    /**
     * 分页查询
     */
    @Deprecated
    cn.com.duiba.biz.tool.duiba.dto.page.Page<SeedRedPacketDto> findByPage(cn.com.duiba.biz.tool.duiba.dto.page.PageQuery pageQuery, String title);

    /**
     * 分页查询
     */
    Page<SeedRedPacketDto> findByPageApi(PageQuery pageQuery, String title);

    /**
     * 查看详情
     */
    SeedRedPacketDto findById(Long id);

}
