package cn.com.duiba.activity.center.api.remoteservice.vote;

import cn.com.duiba.activity.center.api.dto.vote.VoteConfigDto;
import cn.com.duiba.activity.center.api.dto.vote.VoteConfigSimpleDto;
import cn.com.duiba.activity.center.api.dto.vote.VoteMainDto;
import cn.com.duiba.activity.center.api.dto.vote.VotePlayerInfoDto;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Author: lufeng
 * @Description:投票活动service
 * @Date: Created in 2018/10/15
 */
@AdvancedFeignClient
public interface RemoteVoteService {

    /*
    * 添加投票配置信息（包含基础规则，投票规则，自定义字段管理）
    * */
    Integer insertVoteConfig(VoteConfigDto dto);

    /*
    * 修改投票配置信息
    * */
    Integer updateVoteConfig(VoteConfigDto dto);

    /*
    * 删除投票配置信息
    * */
    Integer deleteVoteConfigInfo(Long id);

    /*
    * 查询某个投票配置具体信息
    * */
    VoteConfigDto findVoteConfig(Long id);

    /*
     * 查询结束时间为当前时间前第七天的所有投票活动
     * */
    List<VoteConfigDto> listVoteConfigAfterCloseTime7days();

    /*
     * 批量新增参赛者信息
     * */
    Integer batchInsertVotePlayerInfo(List<VotePlayerInfoDto> list);

    /*
    * 投票配置信息列表（简单列表）
    * */
    @Deprecated
    cn.com.duiba.biz.tool.duiba.dto.page.Page<VoteConfigSimpleDto> listVoteConfigSimplePage(VoteConfigSimpleDto dto, Integer pageSize, Integer pageNo);

    /*
    * 投票配置信息列表（简单列表）
    * */
    Page<VoteConfigSimpleDto> listVoteConfigSimplePageApi(VoteConfigSimpleDto dto, Integer pageSize, Integer pageNo);

    /*
    * 参赛者禁赛/恢复(禁赛：从Redis中持久化到数据库，并清除对应缓存；恢复：从数据库中同步到Redis)
     */
//    Integer banOrRecoverVotePlayer(Long votePlayerId);

    /*
    * 从投票配置信息表中获取参赛者模版显示的自定义字段
    * */
    String getExtraFields(Long id);

    /*
     * 获得投票主页面入口（有可能多个活动）
     * */
    List<VoteMainDto> listVoteMain(List<Long> ids);




}
