/**
 * Project Name:activity-center-biz
 * File Name:SignConfigDao.java
 * Package Name:cn.com.duiba.activity.center.biz.dao.sign
 * Date:2016年10月22日下午1:33:58
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.remoteservice.sign;

import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.sign.SignConfigDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:SignConfigDao <br/>
 * Date:     2016年10月22日 下午1:33:58 <br/>
 * @author   liyang
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteSignConfigService {
    /**
     * 
     * findAllByIds:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param ids
     * @return
     * @since JDK 1.6
     */
    List<SignConfigDto> findAllByIds(List<Long> ids);

    /**
     * 获取app是否开启签到弹层的对应关系
     * @param appIds
     * @return
     */
    Map<Long,Boolean> findOpenSignAppMap(List<Long> appIds);
    /**
     * 
     * findByPage:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param offset
     * @param max
     * @param title
     * @param id
     * @return
     * @since JDK 1.6
     */
    List<SignConfigDto> findByPage(Long appId, Integer offset, Integer max, String title, Integer id);
    /**
     * 
     * findByPageCount:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param title
     * @param id
     * @return
     * @since JDK 1.6
     */
    Long findByPageCount(Long appId, String title, Integer id);
    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    SignConfigDto find(Long id);
    
    SignConfigDto findByAppId(Long appId);
    /**
     * 
     * add:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param sign
     * @return
     * @since JDK 1.6
     */
    SignConfigDto add(SignConfigDto sign);
    
    /**
     * 
     * delete:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @since JDK 1.6
     */
    void delete(Long id, Long appId);
    /**
     * 
     * update:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param sign
     * @since JDK 1.6
     */
    void update(SignConfigDto sign);
    
    /**
     * 
     * updateStatus:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @param status
     * @return
     * @since JDK 1.6
     */
    int updateStatus(Long id, Integer status, Long appId);
    
    /**
     * 
     * createOrder:(这里用一句话描述这个方法的作用). <br/>
     * 生成订单  出奖
     * @param consumerId
     * @param transfer
     * @param ip
     * @param description
     * @param ua
     * @param os
     * @param signDto
     * @param signDays
     * @param addCredits
     * @return
     * @since JDK 1.6
     */
    DubboResult<String> createOrder(Long consumerId,String ip,SignConfigDto signDto, Long addCredits);
    
    void asyncConsumerPlug(Long appId, Long consumerId, String orderNum,String ip,String ua,
                                  String os, SignConfigDto signDto, Integer signDays) throws BusinessException;
}

