package cn.com.duiba.activity.center.api.dto.flow;

import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 流量特征数据
 * Created by zzy on 2017/4/19.
 */
public class FlowFeatureDto implements Serializable {

    private static final long serialVersionUID = 8371152103411149145L;

    /**
     * 所属APP ID
     */
    @NotNull
    private Long appId;

    /**
     * 活动类型
     */
    @NotNull
    private Integer activityType;
    /**
     * 请求地区编码,取ip库code前4位
     */
    @NotEmpty
    private String cityCode;

    /**
     * 是否是代理流量
     */
    private boolean byproxy;
    /**
     * 请求时间
     */
    private Date time = new Date();

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public Date getTime() {
        return time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public boolean isByproxy() {
        return byproxy;
    }

    public void setByproxy(boolean byproxy) {
        this.byproxy = byproxy;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("FlowFeatureDto{");
        sb.append("appId=").append(appId);
        sb.append(", activityType=").append(activityType);
        sb.append(", cityCode='").append(cityCode).append('\'');
        sb.append(", time=").append(time);
        sb.append('}');
        return sb.toString();
    }
}
