package cn.com.duiba.activity.center.api.enums;

/**
 * Created by Liugq on 2018/12/21.
 * 活动投放渠道
 */
public enum ActThrowChannelEnum {
    CHNNEL_APP(0, "app"),
    CHNNEL_PUBLIC(1, "公众号"),
    CHNNEL_SERVICE(2, "服务号"),
    ;


    private Integer code;
    private String desc;

    ActThrowChannelEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ActThrowChannelEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (ActThrowChannelEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
