package cn.com.duiba.activity.center.api.remoteservice.betv2;

import cn.com.duiba.activity.center.api.dto.betv2.BetV2ListRecordDto;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * RemoteBetV2RecordService
 *
 * @author ChenXiangge
 * @date 28/06/2018
 */
@AdvancedFeignClient
public interface RemoteBetV2RecordService {

    /**
     * 往日胜利战绩
     * @param consumerId
     * @param appId
     * @param pageNo
     * @param pageSize
     * @return
     */
    Page<BetV2ListRecordDto> list(Long consumerId, Long appId, Integer pageNo, Integer pageSize);

    /**
     * 活动用户参与pk活动的次数
     * @param consumerId  用户id
     * @return 押注的总次数
     */
    Long findBetTimesByConsumerId(Long consumerId);

    /**
     * 是否可以插件抽奖
     * @param betId pk赛活动
     * @param consumerId 用户id
     * @return 是否可以插件抽奖
     */
    Boolean ifICanDraw(Long betId, Long consumerId);
}
