package cn.com.duiba.activity.center.api.remoteservice.lotterysquare;

import cn.com.duiba.activity.center.api.dto.lotterysquare.LotterySquareBonusRecordDto;
import cn.com.duiba.activity.center.api.enums.LSExchangeStatusEnum;
import cn.com.duiba.activity.center.api.enums.LSPrizeTypeEnum;
import cn.com.duiba.activity.center.api.params.LotterySquareRecordQueryParam;
import cn.com.duiba.biz.tool.duiba.dto.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.utils.BeanUtils;

import java.util.List;

/**
 * @Author chenxiangge
 * @Date 2018/12/17
 */
@AdvancedFeignClient
public interface RemoteLotterySquareRecordService {
    Long insert(LotterySquareBonusRecordDto lotterySquareBonusRecordDto);

    int update(LotterySquareBonusRecordDto lotterySquareBonusRecordDto);

    List<LotterySquareBonusRecordDto> selectBonusRecordByParam(LotterySquareRecordQueryParam param);

    Page<LotterySquareBonusRecordDto> selectSuccessRecordByPage(LotterySquareRecordQueryParam param);

    int updateExchangeStatus(Long recordId, LSExchangeStatusEnum exchangeStatus);

    int setBonusRecordToRead(Long recordId);

    Long getTotalSendBonus(Long activityId);

    /**
     * 获取用户在某一活动获得总奖励
     *
     * @param activityId
     * @param consumerId
     * @return
     */
    Long getConsumerTotalBonus(Long activityId, Long consumerId);

    LotterySquareBonusRecordDto findById(Long id);

}
