package cn.com.duiba.activity.center.api.dto.movebrick;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by sunchangji on 2018/12/28.
 */
public class DuibaBrickConfigDto implements Serializable{
	private static final long serialVersionUID = 465341083603593065L;
	/**
	 * 主键id
	 */
	private Long id;

	/**
	 * 应用id
	 */
	private Long appId;

	/**
	 * 活动入库表id
	 */
	private Long opId;

	/**
	 * 活动名称
	 */
	private String title;

	/**
	 * 奖励类型。1:实物，2:红包，3:实物+红包
	 * @see cn.com.duiba.activity.center.api.enums.BrickRewardTypeEnum
	 */
	private int rewardType;

	/**
	 * 活动需要扣的积分数
	 */
	private int credits;

	/**
	 * 活动开始时间
	 */
	private Date startTime;

	/**
	 * 活动结束时间
	 */
	private Date endTime;

	/**
	 * 规则
	 */
	private String brickRule;

	/**
	 * 可中奖用户总人数
	 */
	private int winPrizeNum;

	/**
	 * 已中奖用户总人数
	 */
	private int winnedPrizeNum;

	/**
	 * 实物奖品库存预警邮箱
	 */
	private String objectPrizeWarnEmail;

	/**
	 * 领取奖品所需总砖块数
	 */
	private int exchangeTotalQuantity;

	/**
	 * 红包总预算。以分为单位
	 */
	private int redPacketBudget;

	/**
	 * 实物奖品未中奖用户可的总砖块数
	 */
	private int objectNotWinLimit;

	/**
	 * 单个非中奖用户发放额度
	 */
	private int redPacketNotWinLimit;

	/**
	 * 每次召唤可点击时间（秒）
	 */
	private int clickTime;

	/**
	 * 初级搬砖工召唤间隔时间（分）
	 */
	private int primaryCallInterval;

	/**
	 * 中级搬砖工召唤间隔时间（分）
	 */
	private int middleCallInterval;

	/**
	 * 高级搬砖工召唤间隔时间（分）
	 */
	private int seniorCallInterval;

	/**
	 * 初级搬砖工搬砖时间（分）
	 */
	private int primaryWork;

	/**
	 * 中级搬砖工搬砖时间（分）
	 */
	private int middleWork;

	/**
	 * 高级搬砖工搬砖时间（分）
	 */
	private int seniorWork;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getOpId() {
		return opId;
	}

	public void setOpId(Long opId) {
		this.opId = opId;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public int getRewardType() {
		return rewardType;
	}

	public void setRewardType(int rewardType) {
		this.rewardType = rewardType;
	}

	public int getCredits() {
		return credits;
	}

	public void setCredits(int credits) {
		this.credits = credits;
	}

	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public String getBrickRule() {
		return brickRule;
	}

	public void setBrickRule(String brickRule) {
		this.brickRule = brickRule;
	}

	public int getWinPrizeNum() {
		return winPrizeNum;
	}

	public void setWinPrizeNum(int winPrizeNum) {
		this.winPrizeNum = winPrizeNum;
	}

	public int getWinnedPrizeNum() {
		return winnedPrizeNum;
	}

	public void setWinnedPrizeNum(int winnedPrizeNum) {
		this.winnedPrizeNum = winnedPrizeNum;
	}

	public String getObjectPrizeWarnEmail() {
		return objectPrizeWarnEmail;
	}

	public void setObjectPrizeWarnEmail(String objectPrizeWarnEmail) {
		this.objectPrizeWarnEmail = objectPrizeWarnEmail;
	}

	public int getExchangeTotalQuantity() {
		return exchangeTotalQuantity;
	}

	public void setExchangeTotalQuantity(int exchangeTotalQuantity) {
		this.exchangeTotalQuantity = exchangeTotalQuantity;
	}

	public int getRedPacketBudget() {
		return redPacketBudget;
	}

	public void setRedPacketBudget(int redPacketBudget) {
		this.redPacketBudget = redPacketBudget;
	}

	public int getObjectNotWinLimit() {
		return objectNotWinLimit;
	}

	public void setObjectNotWinLimit(int objectNotWinLimit) {
		this.objectNotWinLimit = objectNotWinLimit;
	}

	public int getRedPacketNotWinLimit() {
		return redPacketNotWinLimit;
	}

	public void setRedPacketNotWinLimit(int redPacketNotWinLimit) {
		this.redPacketNotWinLimit = redPacketNotWinLimit;
	}

	public int getClickTime() {
		return clickTime;
	}

	public void setClickTime(int clickTime) {
		this.clickTime = clickTime;
	}

	public int getPrimaryCallInterval() {
		return primaryCallInterval;
	}

	public void setPrimaryCallInterval(int primaryCallInterval) {
		this.primaryCallInterval = primaryCallInterval;
	}

	public int getMiddleCallInterval() {
		return middleCallInterval;
	}

	public void setMiddleCallInterval(int middleCallInterval) {
		this.middleCallInterval = middleCallInterval;
	}

	public int getSeniorCallInterval() {
		return seniorCallInterval;
	}

	public void setSeniorCallInterval(int seniorCallInterval) {
		this.seniorCallInterval = seniorCallInterval;
	}

	public int getPrimaryWork() {
		return primaryWork;
	}

	public void setPrimaryWork(int primaryWork) {
		this.primaryWork = primaryWork;
	}

	public int getMiddleWork() {
		return middleWork;
	}

	public void setMiddleWork(int middleWork) {
		this.middleWork = middleWork;
	}

	public int getSeniorWork() {
		return seniorWork;
	}

	public void setSeniorWork(int seniorWork) {
		this.seniorWork = seniorWork;
	}
}
