package cn.com.duiba.activity.center.api.remoteservice.movebrick;

import cn.com.duiba.activity.center.api.dto.movebrick.DuibaBrickConfigDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * Created by sunchangji on 2018/12/28.
 */
@AdvancedFeignClient
public interface RemoteDuibaBrickConfigService {

	/**
	 * 获取第几期活动配置
	 *
	 * @param appId 应用id
	 * @param period 期次,目前只有2期
	 * @return 按开始时间排序
	 */
	DuibaBrickConfigDto findPeriodBrick(Long appId,int period);

	/**
	 * 新增
	 *
	 * @param configDto
	 * @return 新增后的主键id
	 */
	Long insertBrickConfig(DuibaBrickConfigDto configDto);

	/**
	 * 查询当前时间之后共有多少期
	 *
	 * @param appId 应用id
	 * @return
	 */
	int findPeriod(Long appId);

}
