package cn.com.duiba.activity.center.api.remoteservice.movebrick;

import cn.com.duiba.activity.center.api.dto.movebrick.DuibaBrickAccountDto;
import cn.com.duiba.activity.center.api.dto.movebrick.DuibaBrickExchangeRecordDto;
import cn.com.duiba.activity.center.api.dto.movebrick.DuibaBrickMarkedDto;
import cn.com.duiba.activity.center.api.dto.movebrick.DuibaBrickMobileDateDto;
import cn.com.duiba.activity.center.api.dto.movebrick.DuibaBrickWorkerDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Author: lufeng
 * @Description:搬砖活动 针对手机端获取除配置以外的动态数据
 * @Date: Created in 2018/12/28
 */
@AdvancedFeignClient
public interface RemoteDuibaBrickMobileDataService {

    //获取搬砖活动主页面动态数据
    DuibaBrickMobileDateDto getBrickMobieDate(Long brickConfigId, Long consumerId);

    /*
     * 获取搬砖工到当前时间可获取的砖块数
     * */
    Integer getWorkerBrickNum(Long brickConfigId, Long consumerId);

    /*
     * 获取已标记用户
     * */
    List<DuibaBrickMarkedDto> getMarkedUser(Long brickConfigId);

    /*
     * 标记用户逻辑
     * */
    boolean markUser(Long brickConfigId, Long consumerId, Integer prizeType, Long brickPrizeId);

    /*
     * 新增搬砖工批次
     * */
    Long addBrickWorker(DuibaBrickWorkerDto brickWorkerDto);

    /*
     * 获取当前用户使用的账户
     * */
    DuibaBrickAccountDto getBrickAccount(Long brickConfigId, Long consumerId);

    /*
     * 获取当前用户的已兑换的奖品信息
     * */
    List<DuibaBrickAccountDto> listBrickAccountHaveExchange(Long brickConfigId, Long consumerId);

    /*
     * 将原账户置为已兑换
     * */
    boolean exchangeAccountBrickNum(Long accountId, Integer exchangeBrick);

    /*
     * 新建账户
     * */
    Long insertBrickAccount(DuibaBrickAccountDto brickAccountDto);

    /*
     * 删除账户
     * */
    boolean deleteBrickAccount(Long brickConfigId, Long consumerId);

    /*
     * 新增兑换记录
     * */
    Long insertBrickExchangeRecord(DuibaBrickExchangeRecordDto brickExchangeRecordDto);

}
