package cn.com.duiba.activity.center.api.remoteservice.movebrick;

import cn.com.duiba.activity.center.api.dto.movebrick.DuibaBrickMarkedDto;
import cn.com.duiba.activity.center.api.dto.movebrick.DuibaBrickMobileDateDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Author: lufeng
 * @Description:搬砖活动 针对手机端获取除配置以外的动态数据
 * @Date: Created in 2018/12/28
 */
@AdvancedFeignClient
public interface RemoteDuibaBrickMobileDataService {

    DuibaBrickMobileDateDto getBrickMobieDate(Long brickConfigId, Long consumerId);

    /*
     * 获取某批次搬砖工到当前时间可获取的砖块数
     * */
    Integer getWorkerBrickNum(Long brickConfigId, Long consumerId, Long workerId);

    /*
     * 获取已标记用户
     * */
    List<DuibaBrickMarkedDto> getMarkedUser(Long brickConfigId);
}
