package cn.com.duiba.activity.center.api.remoteservice.movebrick;

import cn.com.duiba.activity.center.api.dto.movebrick.DuibaBrickConfPrizesDto;
import cn.com.duiba.activity.center.api.dto.movebrick.DuibaBrickConfigDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 开发者管理端使用服务
 * <p>
 * Created by sunchangji on 2018/12/29.
 */
@AdvancedFeignClient
public interface RemoteDuibaBrickConfBackendService {

	/**
	 * 获取第几期活动配置
	 *
	 * @param appId     应用id
	 * @param period    期次,目前只有2期
	 * @param ruleMerge 是否需要将默认规则和自定义规则合并为一个字段,true:合并,false:不合并,只取开发者自定义的规则
	 * @return 按开始时间排序
	 */
	DuibaBrickConfigDto findPeriodBrick(Long appId, int period, boolean ruleMerge);

	/**
	 * 查询活动详细信息,包括奖品信息
	 *
	 * @param appId     应用id
	 * @param period    期次,目前只有2期
	 * @param ruleMerge 是否需要将默认规则和自定义规则合并为一个字段,true:合并,false:不合并,只取开发者自定义的规则
	 * @return
	 */
	DuibaBrickConfPrizesDto findBrickConfDetails(Long appId, int period, boolean ruleMerge);

	/**
	 * 查询最近的全部期次活动配置,目前最多只有2期
	 *
	 * @param appId     应用id
	 * @param ruleMerge 是否需要将默认规则和自定义规则合并为一个字段,true:合并,false:不合并,只取开发者自定义的规则
	 * @return 按开始时间排序
	 */
	List<DuibaBrickConfigDto> findNearestBricks(Long appId, boolean ruleMerge);

	/**
	 * 新增
	 *
	 * @param brickConfPrizesDto
	 * @return 新增后的主键id
	 */
	boolean insertBrickConfig(DuibaBrickConfPrizesDto brickConfPrizesDto);

	/**
	 * 查询当前时间之后共有多少期
	 *
	 * @param appId 应用id
	 * @return
	 */
	int findPeriod(Long appId);

	/**
	 * @param id        配置主键id
	 * @return
	 */
	DuibaBrickConfigDto findById(Long id);

	/**
	 * 更新配置信息
	 *
	 * @param brickConfPrizesDto
	 * @return
	 */
	boolean updateBrickConfig(DuibaBrickConfPrizesDto brickConfPrizesDto);


	/**
	 * 根据入库id查询活动配置
	 * @param opId 入库活动id
	 * @return
	 */
	DuibaBrickConfigDto findByOpId(Long opId);
}
