package cn.com.duiba.activity.center.api.enums;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @author liukai
 * @Description: 确认预算记录业务类型
 * @date 2019/1/1212:15 PM
 */
public enum BudgetBizTypeEnum {

    PK(1, "pk"),
    BUICK(2, "搬砖工"),
    ;

    private Integer code;
    private String desc;

    public static final ImmutableMap<Integer, BudgetBizTypeEnum> BudgetBizType_MAP;

    static {
        Map<Integer, BudgetBizTypeEnum> temp = Maps.newHashMap();
        for (BudgetBizTypeEnum budgetBizTypeEnum : values()) {
            temp.put(budgetBizTypeEnum.getCode(), budgetBizTypeEnum);
        }
        BudgetBizType_MAP = ImmutableMap.copyOf(temp);
    }

    BudgetBizTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    public BudgetBizTypeEnum getBetActivityBonusTypeNum(Integer code) {
        if(BudgetBizType_MAP.containsKey(code)){
            return BudgetBizType_MAP.get(code);
        }else{
            return null;
        }
    }



}
