package cn.com.duiba.activity.center.api.enums;

/**
 * Created by Liugq on 2018/12/21.
 * 红包广场奖励额度类型
 */
public enum LSBonusStyleEnum {
    BONUS_FIXED_AMOUNT(0, "固定额度"),
    BONUS_RANDOM(1, "随机区间"),
    ;


    private Integer code;
    private String desc;

    LSBonusStyleEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static LSBonusStyleEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (LSBonusStyleEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
