/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.api.dto.duibaactivity;

import cn.com.duiba.service.exception.ServiceInternalException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DuibaActivityDto
implements Serializable {
    private static final long serialVersionUID = -4556721268810826180L;
    private static final String ITEMS = "items";
    public static final Integer LAYOUT_ONE = 1;
    public static final Integer LAYOUT_TWO = 2;
    public static final Integer SWITCHES_DIRECT = 0;
    public static final Integer SWITCHES_DEV_BLACKLIST = 1;
    public static final Integer STATUS_UNPUBLISH = 0;
    public static final Integer STATUS_STARTUP = 1;
    public static final Integer STATUS_SHUTDOWN = 2;
    public static final Integer TYPE_ACTIVITY = 0;
    public static final Integer PUSH = 1;
    public static final Integer NOT_PUSH = 0;
    private Long id;
    private String title;
    private String subtitle;
    private String logo;
    private String smallImage;
    private String whiteImage;
    private String indexBannerImage;
    private String topicBannerImage;
    private String cssUrl;
    private Integer layout;
    private String areasImagesItems;
    private Integer type;
    private String rule;
    private Integer status;
    private Integer activityOrderQuantity;
    private Boolean deleted;
    private Date gmtCreate;
    private Date gmtModified;
    private Integer switches;
    private Date autoOffDate;
    private String recommendImage;

    public DuibaActivityDto() {
    }

    public DuibaActivityDto(Long id) {
        this.id = id;
        this.gmtModified = new Date();
    }

    public DuibaActivityDto(boolean init4insert) {
        if (init4insert) {
            this.status = 0;
            this.activityOrderQuantity = 0;
            this.deleted = false;
            this.type = 0;
            this.switches = 0;
            this.gmtModified = this.gmtCreate = new Date();
        }
    }

    public void openSwitch(int s) {
        int v = 1 << s;
        this.switches = this.switches | v;
    }

    public void closeSwitch(int s) {
        int v = 1 << s;
        this.switches = this.switches & (v ^= 0xFFFFFFFF);
    }

    public boolean isOpenSwitch(int s) {
        int v = 1 << s;
        int ret = this.switches & v;
        return ret != 0;
    }

    public String toString() {
        return "DuibaActivityDO [id=" + this.id + ", title=" + this.title + "]";
    }

    public Integer getSwitches() {
        return this.switches;
    }

    public void setSwitches(Integer switches) {
        this.switches = switches;
    }

    public Long getId() {
        return this.id;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getSmallImage() {
        return this.smallImage;
    }

    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    public String getIndexBannerImage() {
        return this.indexBannerImage;
    }

    public void setIndexBannerImage(String indexBannerImage) {
        this.indexBannerImage = indexBannerImage;
    }

    public String getTopicBannerImage() {
        return this.topicBannerImage;
    }

    public void setTopicBannerImage(String topicBannerImage) {
        this.topicBannerImage = topicBannerImage;
    }

    public String getCssUrl() {
        return this.cssUrl;
    }

    public void setCssUrl(String cssUrl) {
        this.cssUrl = cssUrl;
    }

    public Integer getLayout() {
        return this.layout;
    }

    public void setLayout(Integer layout) {
        this.layout = layout;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getAreasImagesItems() {
        return this.areasImagesItems;
    }

    public void setAreasImagesItems(String areasImagesItems) {
        this.areasImagesItems = areasImagesItems;
    }

    public String getRule() {
        return this.rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getActivityOrderQuantity() {
        return this.activityOrderQuantity;
    }

    public void setActivityOrderQuantity(Integer activityOrderQuantity) {
        this.activityOrderQuantity = activityOrderQuantity;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return this.gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return this.gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getAutoOffDate() {
        return this.autoOffDate;
    }

    public void setAutoOffDate(Date autoOffDate) {
        this.autoOffDate = autoOffDate;
    }

    public List<DuibaActivityArea> getDuibaActivityAreaList() {
        ArrayList<DuibaActivityArea> list = new ArrayList<DuibaActivityArea>();
        if (!StringUtils.isBlank((String)this.areasImagesItems)) {
            JSONObject o = JSON.parseObject((String)this.areasImagesItems);
            for (int i = 1; i <= o.size(); ++i) {
                DuibaActivityArea a = new DuibaActivityArea();
                JSONObject tmp = JSON.parseObject((String)o.getString(String.valueOf(i)));
                a.setImage(tmp.getString("image"));
                ArrayList<Long> b = new ArrayList<Long>();
                ArrayList<Integer> c = new ArrayList<Integer>();
                for (int j = 0; j < tmp.getJSONArray(ITEMS).size(); ++j) {
                    JSONObject t = (JSONObject)tmp.getJSONArray(ITEMS).get(j);
                    b.add(t.getLong("itemId"));
                    c.add(t.getInteger("push"));
                }
                a.setItemIds(b);
                a.setPushs(c);
                list.add(a);
            }
        }
        return list;
    }

    public static String getAreasJSONString(List<Integer> indexs, List<String> images, List<String> items, List<String> pushButtons) {
        if (indexs == null || images == null || items == null || pushButtons == null) {
            throw new ServiceInternalException("\u5151\u6362\u533a\u57df\u6570\u636e\u9519\u8bef");
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("{");
        for (int i = 0; i < indexs.size(); ++i) {
            buffer.append("\"" + indexs.get(i) + "\"");
            buffer.append(":{\"image\":");
            buffer.append("\"" + images.get(i) + "\"");
            buffer.append(",\"items\":[");
            String tmp = items.get(i);
            String pbt = pushButtons.get(i);
            if (StringUtils.isNotBlank((String)tmp)) {
                String[] ii = tmp.split(",");
                String[] pp = pbt.split(",");
                for (int j = 0; j < ii.length; ++j) {
                    buffer.append("{\"itemId\":");
                    buffer.append(ii[j]);
                    buffer.append(", \"push\":");
                    buffer.append(pp[j]);
                    buffer.append("}");
                    if (j >= ii.length - 1) continue;
                    buffer.append(",");
                }
            }
            buffer.append("]}");
            if (i >= indexs.size() - 1) continue;
            buffer.append(",");
        }
        buffer.append("}");
        return buffer.toString();
    }

    public static String getAreasJSONString(Object areaImage, Object areaItems, Object pushButton) {
        String[] tmp;
        String[] areaImages = null;
        String[] areaItemss = null;
        String[] pushButtons = null;
        if (areaImage instanceof String) {
            tmp = new String[]{(String)areaImage};
            areaImages = tmp;
        } else {
            areaImages = (String[])areaImage;
        }
        if (areaItems instanceof String) {
            tmp = new String[]{(String)areaItems};
            areaItemss = tmp;
        } else {
            areaItemss = (String[])areaItems;
        }
        if (pushButton instanceof String) {
            tmp = new String[]{(String)pushButton};
            pushButtons = tmp;
        } else {
            pushButtons = (String[])pushButton;
        }
        ArrayList<String> areaImagesList = new ArrayList<String>(Arrays.asList(areaImages));
        ArrayList<String> areaItemssList = new ArrayList<String>(Arrays.asList(areaItemss));
        ArrayList<String> pushButtonsList = new ArrayList<String>(Arrays.asList(pushButtons));
        Iterator i1 = areaImagesList.iterator();
        Iterator i2 = areaItemssList.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            String e1 = (String)i1.next();
            String e2 = (String)i2.next();
            if (!StringUtils.isBlank((String)e1) || !StringUtils.isBlank((String)e2)) continue;
            i1.remove();
            i2.remove();
        }
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        for (int i = 1; i <= areaImagesList.size(); ++i) {
            indexs.add(i);
        }
        return DuibaActivityDto.getAreasJSONString(indexs, areaImagesList, areaItemssList, pushButtonsList);
    }

    public boolean ifItemIdInActivity(Long itemId) {
        if (StringUtils.isBlank((String)this.areasImagesItems)) {
            throw new ServiceInternalException("\u65e0\u5151\u6362\u9879");
        }
        JSONObject o = JSON.parseObject((String)this.areasImagesItems);
        for (int i = 1; i <= o.size(); ++i) {
            JSONObject tmp = JSON.parseObject((String)o.getString(String.valueOf(i)));
            for (int j = 0; j < tmp.getJSONArray(ITEMS).size(); ++j) {
                JSONObject t = (JSONObject)tmp.getJSONArray(ITEMS).get(j);
                if (!itemId.equals(t.getLong("itemId"))) continue;
                return true;
            }
        }
        return false;
    }

    public static Long getOperatingActivityId(Long itemId, String ids) {
        JSONObject json = JSON.parseObject((String)ids);
        for (String key : json.keySet()) {
            JSONArray array = json.getJSONObject(key).getJSONArray(ITEMS);
            for (int i = 0; i < array.size(); ++i) {
                Long ii = array.getLong(i);
                if (!itemId.equals(ii)) continue;
                return Long.valueOf(key);
            }
        }
        return null;
    }

    public String getActivityItemIds() {
        String result;
        if (StringUtils.isBlank((String)this.areasImagesItems)) {
            return null;
        }
        JSONObject o = JSON.parseObject((String)this.areasImagesItems);
        StringBuilder buffer = new StringBuilder();
        for (int i = 1; i <= o.size(); ++i) {
            JSONObject tmp = JSON.parseObject((String)o.getString(String.valueOf(i)));
            int size = tmp.getJSONArray(ITEMS).size();
            for (int j = 0; j < size; ++j) {
                JSONObject t = (JSONObject)tmp.getJSONArray(ITEMS).get(j);
                buffer.append(t.getLong("itemId"));
                buffer.append(",");
            }
        }
        return result.substring(0, (result = buffer.toString()).length() != 0 ? result.length() - 1 : 0);
    }

    public List<Long> getActivityItemIdList() {
        ArrayList<Long> idList = new ArrayList<Long>();
        if (!StringUtils.isBlank((String)this.areasImagesItems)) {
            JSONObject o = JSON.parseObject((String)this.areasImagesItems);
            for (int i = 1; i <= o.size(); ++i) {
                JSONObject tmp = JSON.parseObject((String)o.getString(String.valueOf(i)));
                int size = tmp.getJSONArray(ITEMS).size();
                for (int j = 0; j < size; ++j) {
                    JSONObject t = (JSONObject)tmp.getJSONArray(ITEMS).get(j);
                    idList.add(t.getLong("itemId"));
                }
            }
        }
        return idList;
    }

    public Map<Long, Integer> getDuibaActivityItemPushMap() {
        if (StringUtils.isBlank((String)this.areasImagesItems)) {
            return null;
        }
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        JSONObject o = JSON.parseObject((String)this.areasImagesItems);
        for (int i = 1; i <= o.size(); ++i) {
            JSONObject tmp = JSON.parseObject((String)o.getString(String.valueOf(i)));
            for (int j = 0; j < tmp.getJSONArray(ITEMS).size(); ++j) {
                JSONObject t = (JSONObject)tmp.getJSONArray(ITEMS).get(j);
                Integer push = t.getInteger("push");
                Integer val = (Integer)map.get(t.getLong("itemId"));
                this.setDuibaActivityItemPushMap(push, val, map, t);
            }
        }
        return map;
    }

    private void setDuibaActivityItemPushMap(Integer push, Integer val, Map<Long, Integer> map, JSONObject t) {
        if (push == null) {
            push = NOT_PUSH;
        }
        if (val == null) {
            map.put(t.getLong("itemId"), push == PUSH ? PUSH : NOT_PUSH);
        } else if (val == NOT_PUSH && push == PUSH) {
            map.put(t.getLong("itemId"), push);
        }
    }

    public String getWhiteImage() {
        return this.whiteImage;
    }

    public void setWhiteImage(String whiteImage) {
        this.whiteImage = whiteImage;
    }

    public String getRecommendImage() {
        return this.recommendImage;
    }

    public void setRecommendImage(String recommendImage) {
        this.recommendImage = recommendImage;
    }

    public static class DuibaActivityArea
    implements Serializable {
        private static final long serialVersionUID = -13125L;
        private String image;
        private List<Long> itemIds;
        private List<Integer> pushs;

        public String getImage() {
            return this.image;
        }

        public void setImage(String image) {
            this.image = image;
        }

        public List<Long> getItemIds() {
            return this.itemIds;
        }

        public void setItemIds(List<Long> itemIds) {
            this.itemIds = itemIds;
        }

        public List<Integer> getPushs() {
            return this.pushs;
        }

        public void setPushs(List<Integer> pushs) {
            this.pushs = pushs;
        }

        public String toString() {
            return "DuibaActivityArea [image=" + this.image + ", itemIds=" + this.itemIds + ", pushs=" + this.pushs + "]";
        }
    }
}

