package cn.com.duiba.activity.center.api.remoteservice.bargain;

import cn.com.duiba.activity.center.api.dto.bargain.BargainItemInfoDto;
import cn.com.duiba.activity.center.api.params.bargain.BargainItemInfoParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteBargainItemInfoService {

    /**
     * 插入
     *
     * @param pojo
     * @return id
     */
    Long insert(BargainItemInfoDto pojo);

    /**
     * 变更商品库存
     * @param id 商品id
     * @param num  增加或者减少的数量
     * @return
     */
    Integer updateRemaining(Long id,Integer num);

    /**
     * 批量插入
     *
     * @param pojos
     * @return ids集合，按照顺序
     */
    List<Long> batchInsert(List<BargainItemInfoDto> pojos);

    /**
     * 通过商品id查询
     *
     * @param id
     * @return
     */
    BargainItemInfoDto findById(Long id);

    /**
     * 通过商品id批量查询
     * @param ids
     * @return
     */
    List<BargainItemInfoDto> findByIds(List<Long> ids);

    /**
     * 分页查询
     *
     * @param pojo
     * @return
     */
    Page<BargainItemInfoDto> pageByParam(BargainItemInfoParam pojo);

    /**
     * 查询
     *
     * @param pojo
     * @return
     */
    List<BargainItemInfoDto> listByParam(BargainItemInfoParam pojo);

    /**
     * 查询商品列表条数
     *
     * @param pojo
     * @return
     */
    Integer countByParam(BargainItemInfoParam pojo);

    /**
     * 修改
     * 1.id必传，根据id修改
     *
     * @param pojo
     * @return
     */
    int update(BargainItemInfoDto pojo);


    /**
     * 修改商品砍价成功人数
     * @param id  商品id
     * @param num  变更值
     * @return
     */
    int updateCompletedCountById(Long id,Integer num);

    /**
     * 删除
     *
     * @param id
     * @return
     */
     int deleteById(Long id);

}
