package cn.com.duiba.activity.center.api.remoteservice.movebrick;

import cn.com.duiba.activity.center.api.dto.movebrick.DuibaBrickAccountDto;
import cn.com.duiba.activity.center.api.dto.movebrick.DuibaBrickExchangeRecordDto;
import cn.com.duiba.activity.center.api.dto.movebrick.DuibaBrickMarkedDto;
import cn.com.duiba.activity.center.api.dto.movebrick.DuibaBrickMobileDateDto;
import cn.com.duiba.activity.center.api.dto.movebrick.DuibaBrickWorkerDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Author: lufeng
 * @Description:搬砖活动 针对手机端获取除配置以外的动态数据
 * @Date: Created in 2018/12/28
 */
@AdvancedFeignClient
public interface RemoteDuibaBrickMobileDataService {

    //获取搬砖活动主页面动态数据
    DuibaBrickMobileDateDto getBrickMobieDate(Long brickConfigId, Long consumerId);

    /*
     * 获取搬砖工到当前时间可获取的砖块数
     * */
    Integer getWorkerBrickNum(Long brickConfigId, Long consumerId);

    /*
     * 获取已标记用户
     * */
    List<DuibaBrickMarkedDto> getMarkedUser(Long brickConfigId, Long brickPrizeId);

    /*
     * 取消用户标记
     * */
    boolean cancelMarkedUser(Long brickConfigId, Long consumerId);

    /*
     * 标记用户逻辑
     * */
    boolean markUser(Long brickConfigId, Long consumerId, Integer prizeType, Long brickPrizeId);

    /*
     * 新增搬砖工批次
     * */
    Long addBrickWorker(DuibaBrickWorkerDto brickWorkerDto);

    /*
     * 获取当前用户使用的账户
     * */
    DuibaBrickAccountDto getBrickAccount(Long brickConfigId, Long consumerId);

    /*
     * 获取当前用户的已兑换的奖品信息（因为红包是分多个小红包的）
     * */
    List<DuibaBrickAccountDto> listBrickAccountHaveExchange(Long brickConfigId, Long consumerId);

    /*
     * 将原账户置为已兑换
     * */
    boolean exchangeAccountBrickNum(Long accountId);

    /*
     * 新建账户
     * */
    Long insertBrickAccount(DuibaBrickAccountDto brickAccountDto);

    /**
     * 账户已获取搬砖数倒序，获取前几位账户
     * @param brickConfigId 活动id
     * @param brickPrizeId 活动奖品id
     * @param size 获取的个数
     * @return
     */
    List<DuibaBrickAccountDto> listFrontHaveBrickNum(Long brickConfigId, Long brickPrizeId, int size);

    /*
     * 删除账户
     * */
    boolean deleteBrickAccount(Long brickConfigId, Long consumerId);

    /*
     * 新增兑换记录
     * */
    Long insertBrickExchangeRecord(DuibaBrickExchangeRecordDto brickExchangeRecordDto);

    /*
     * 获取当前用户的已兑换的奖品信息
     * */
    List<DuibaBrickExchangeRecordDto> listBrickExchangeRecord(Long brickConfigId, Long consumerId);

    /**
     * 是否可取消用户标记
     * @param brickConfigId
     * @param consumerId
     * @return
     */
    boolean canCancelMarked(Long brickConfigId, Long consumerId);

    /**
     * 重新标记逻辑（实物）
     * @param brickConfigId 活动id
     * @param brickPrizeId 活动奖品id
     * @param size 可中奖个数
     */
    void afreshMarkObject(Long brickConfigId, Long brickPrizeId, Integer size);

    /**
     * 补砖逻辑（实物/红包都适用）
     * @param brickConfigId
     * @param consumerId
     * @param days 补砖的天数
     */
    void remedyBrickNum(Long brickConfigId, Long consumerId, Integer days);
}
