package cn.com.duiba.activity.center.api.mqmessage;

import cn.com.duiba.activity.center.api.dto.bet.BetConfigDto;
import cn.com.duiba.wolf.utils.GZIPUtils;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;


public class BetOpenPrizeMessage implements Serializable {
    private static final long serialVersionUID = -2519412651206837594L;
    /**
     * appid
     */
    private Long appId;

    private BetConfigDto betConfig;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public BetConfigDto getBetConfig() {
        return betConfig;
    }

    public void setBetConfig(BetConfigDto betConfig) {
        this.betConfig = betConfig;
    }

    public static BetOpenPrizeMessage decode(byte[] msg) {
        String string = GZIPUtils.ungzip(msg);
        if (string.isEmpty()) {
            return null;
        }
        return JSONObject.parseObject(string, BetOpenPrizeMessage.class);
    }

    /**
     * 编码消息，发送时使用
     *
     * @param msg
     * @return
     */
    public static byte[] encode(BetOpenPrizeMessage msg) {
        String string = JSONObject.toJSONString(msg);
        return GZIPUtils.gzip(string);
    }
}

