package cn.com.duiba.activity.center.api.params;

import cn.com.duiba.activity.center.api.enums.SignSourceTypeEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * 签到查询参数
 * Created by xiaoxuda on 2017/12/12.
 */
public class SignInfoQueryParam implements Serializable{
    private static final long serialVersionUID = 2254840556962228722L;
    /**
     * 用户ID
     */
    private Long consumerId;
    /**
     * appId
     */
    private Long appId;
    /**
     * 签到来源
     */
    private SignSourceTypeEnum sourceType;
    /**
     * 签到来源关联ID,签到关联活动时必填
     */
    private Long sourceRelationId;
    /**
     * 查询发起时间
     */
    private Date queryOccurDate;

    public SignInfoQueryParam(){}

    public SignInfoQueryParam(Long appId, Long consumerId, SignSourceTypeEnum sourceType, Long sourceRelationId,
                              Date queryOccurDate){
        this.appId = appId;
        this.consumerId = consumerId;
        this.sourceType = sourceType;
        this.sourceRelationId = sourceRelationId;
        this.queryOccurDate = queryOccurDate;
    }


    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public SignSourceTypeEnum getSourceType() {
        return sourceType;
    }

    public void setSourceType(SignSourceTypeEnum sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceRelationId() {
        return sourceRelationId;
    }

    public void setSourceRelationId(Long sourceRelationId) {
        this.sourceRelationId = sourceRelationId;
    }

    public Date getQueryOccurDate() {
        return queryOccurDate;
    }

    public void setQueryOccurDate(Date queryOccurDate) {
        this.queryOccurDate = queryOccurDate;
    }
}
