package cn.com.duiba.activity.center.api.dto.game;

import cn.com.duiba.api.enums.ItemTypeEnums;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;

/**
 * 
 * ClassName: DuibaQuestionAnswerOrdersDto <br/>
 * date: 2016年11月30日 下午7:57:19 <br/>
 *
 * @author liyang
 * @version 
 * @since JDK 1.6
 */
public class DuibaQuestionAnswerOrdersDto implements Serializable {

	private static final long serialVersionUID = -1249545712631911787L;

	public static final String PREFIX_ORDER = "question-answer-";
	public static final String LUCKY_PREFIX_ORDER = "question-";//用于中福袋的订单前缀，提供给广告平台用

	public static final int StatusCreate = 0; // 处理中
	public static final int StatusConsumeSuccess = 1; // 扣积分成功
	public static final int StatusConsumeFail = 2; // 扣积分失败

	public static final int StatusSuccess = 3; // 成功
	public static final int ExchangeStatusCreate = 0; // 创建
	public static final int ExchangeStatusWait = 1; // 待领取
	public static final int ExchangeStatusSuccess = 2; // 领奖成功
	public static final int ExchangeStatusFail = 3; // 领奖失败

	public static final int ExchangeStatusOverdue = 4; // 未领取，过期
	public static final String PrizeTypeVirtual = ItemTypeEnums.TypeVirtual.getName(); // 虚拟商品
	public static final String PrizeTypeAlipay = ItemTypeEnums.TypeAlipay.getName(); // 支付宝
	public static final String PrizeTypeQB = ItemTypeEnums.TypeQB.getName(); // QB
	public static final String PrizeTypeCoupon = ItemTypeEnums.TypeCoupon.getName(); // 优惠劵
	public static final String PrizeTypeObject = ItemTypeEnums.TypeObject.getName(); // 实物
	public static final String PrizeTypePhonebill = ItemTypeEnums.TypePhonebill.getName(); // 话费
	public static final String PrizeTypeLuckBag = "lucky";//福袋

	private Long id;
	private Long appId;
	private String token;
	private Long consumerId;
	private String partnerUserId;
	private Long operatingActivityId;
	private Long duibaQuestionAnswerId;
	private Integer questionType;
	private Long itemId;
	private Long appItemId;
	private Long credits;
	private Long prizeId;
	private String prizeName;
	private String prizeType;
	private Date prizeOverdueDate;
	private String prizeFacePrice;
	private Integer score;
	private Long couponId;
	private Integer status;
	
	private Integer exchangeStatus;
    private Long mainOrderId;
    private String mainOrderNum;
    private String developerBizId;
    private String ip;
    private String error4admin;
    private String error4developer;
    private String error4consumer;
    private Date gmtCreate;
    private Date gmtModified;
	
	public Integer getQuestionType() {
		return questionType;
	}
	public void setQuestionType(Integer questionType) {
		this.questionType = questionType;
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public Long getAppId() {
		return appId;
	}
	public void setAppId(Long appId) {
		this.appId = appId;
	}
	public String getToken() {
		return token;
	}
	public void setToken(String token) {
		this.token = token;
	}
	public Long getConsumerId() {
		return consumerId;
	}
	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}
	public String getPartnerUserId() {
		return partnerUserId;
	}
	public void setPartnerUserId(String partnerUserId) {
		this.partnerUserId = partnerUserId;
	}
	public Long getOperatingActivityId() {
		return operatingActivityId;
	}
	public void setOperatingActivityId(Long operatingActivityId) {
		this.operatingActivityId = operatingActivityId;
	}
	public Long getDuibaQuestionAnswerId() {
		return duibaQuestionAnswerId;
	}
	public void setDuibaQuestionAnswerId(Long duibaQuestionAnswerId) {
		this.duibaQuestionAnswerId = duibaQuestionAnswerId;
	}
	public Long getItemId() {
		return itemId;
	}
	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}
	public Long getAppItemId() {
		return appItemId;
	}
	public void setAppItemId(Long appItemId) {
		this.appItemId = appItemId;
	}
	public Long getCredits() {
		return credits;
	}
	public void setCredits(Long credits) {
		this.credits = credits;
	}
	public Long getPrizeId() {
		return prizeId;
	}
	public void setPrizeId(Long prizeId) {
		this.prizeId = prizeId;
	}
	public String getPrizeName() {
		return prizeName;
	}
	public void setPrizeName(String prizeName) {
		this.prizeName = prizeName;
	}
	public String getPrizeType() {
		return prizeType;
	}
	public void setPrizeType(String prizeType) {
		this.prizeType = prizeType;
	}
	public Date getPrizeOverdueDate() {
		return prizeOverdueDate;
	}
	public void setPrizeOverdueDate(Date prizeOverdueDate) {
		this.prizeOverdueDate = prizeOverdueDate;
	}
	public String getPrizeFacePrice() {
		return prizeFacePrice;
	}
	public void setPrizeFacePrice(String prizeFacePrice) {
		this.prizeFacePrice = prizeFacePrice;
	}
	public Integer getScore() {
		return score;
	}
	public void setScore(Integer score) {
		this.score = score;
	}
	public Long getCouponId() {
		return couponId;
	}
	public void setCouponId(Long couponId) {
		this.couponId = couponId;
	}
	public Integer getStatus() {
		return status;
	}
	public void setStatus(Integer status) {
		this.status = status;
	}
	public Integer getExchangeStatus() {
		return exchangeStatus;
	}
	public void setExchangeStatus(Integer exchangeStatus) {
		this.exchangeStatus = exchangeStatus;
	}
	public Long getMainOrderId() {
		return mainOrderId;
	}
	public void setMainOrderId(Long mainOrderId) {
		this.mainOrderId = mainOrderId;
	}
	public String getMainOrderNum() {
		return mainOrderNum;
	}
	public void setMainOrderNum(String mainOrderNum) {
		this.mainOrderNum = mainOrderNum;
	}
	public String getDeveloperBizId() {
		return developerBizId;
	}
	public void setDeveloperBizId(String developerBizId) {
		this.developerBizId = developerBizId;
	}
	public String getIp() {
		return ip;
	}
	public void setIp(String ip) {
		this.ip = ip;
	}
	public String getError4admin() {
		return error4admin;
	}
	public void setError4admin(String error4admin) {
		this.error4admin = error4admin;
	}
	public String getError4developer() {
		return error4developer;
	}
	public void setError4developer(String error4developer) {
		this.error4developer = error4developer;
	}
	public String getError4consumer() {
		return error4consumer;
	}
	public void setError4consumer(String error4consumer) {
		this.error4consumer = error4consumer;
	}
	public Date getGmtCreate() {
		return gmtCreate;
	}
	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}
	public Date getGmtModified() {
		return gmtModified;
	}
	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}
	
	/**
	 * 
	 * generateOrderNum:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public static synchronized String generateOrderNum(Long id) {
		return PREFIX_ORDER + id.toString();
	}

	/**
	 * 
	 * generateOrderToken:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @return
	 * @since JDK 1.6
	 */
	public static synchronized String generateOrderToken() {
		String token = UUID.randomUUID().toString();
		token = token.replaceAll("-", "");
		return token;
	}
	
	
}
