package cn.com.duiba.activity.center.api.remoteservice.happycodenew;

import cn.com.duiba.activity.center.api.dto.happycodenew.HappyCodeDetailDto;
import cn.com.duiba.activity.center.api.enums.happycodenew.HappyExchangeStatusEnum;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import java.util.List;

/**
 * Created by Liugq on 2019/3/29.
 */
@AdvancedFeignClient
public interface RemoteHappyCodeDetailService {

    /**
     * 根据bizid修改状态
     * @param status
     * @param bizId
     * @return
     */
    Integer updateOrderStatus(Long phaseId, Long consumerId,String bizId,HappyExchangeStatusEnum status);

    /**
     * 开心码活动定时开奖随机开奖
     */
    void randomPrizeCode();

    /**
     * 发送积分扣减动作后，把初始的订单号改成扣积分的订单号
     * @param phaseId
     * @param consumerId
     * @param oldBizId
     * @param bizId
     * @return
     */
    Integer updateBizId(Long phaseId, Long consumerId, String oldBizId, String bizId);

    /**
     * 根据bizid查询开心码
     * @param phaseId
     * @param consumerId
     * @param bizId
     * @return
     */
    List<HappyCodeDetailDto> selectCodeByBizId(Long phaseId, Long consumerId, String bizId);

    /**
     * 查询用户当前期次所有有效的开心码
     * @param consumerId
     * @param phaseId
     * @return
     */
    List<String> selectUserCodeByPhase(Long consumerId, Long phaseId);

}
