package cn.com.duiba.activity.center.api.remoteservice.happycodenew;

import cn.com.duiba.activity.center.api.dto.happycodenew.HappyCodeItemBasicDto;
import cn.com.duiba.activity.center.api.dto.happycodenew.HappyCodeItemPhaseDto;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import java.util.List;

/**
 * Created by Liugq on 2019/3/29.
 */
@AdvancedFeignClient
public interface RemoteHappyCodeItemPhaseService {

    /**
     * 赛事维度下查询今天或明天的期次，如果没有则插入
     * @param dto
     * @return
     */
    HappyCodeItemPhaseDto findOrInsertPhase(HappyCodeItemBasicDto dto);

    HappyCodeItemPhaseDto findById(Long phaseId);

    /**
     * 分页查询成功开奖的往期记录
     * @param actId
     * @param pageNum
     * @param pageSize
     * @return
     */
    Page<HappyCodeItemPhaseDto> pageQuerySuccessPhase(Long actId, Integer pageNum, Integer pageSize);

    /**
     * 批量查询
      * @param ids
     * @return
     */
    List<HappyCodeItemPhaseDto> selectByIds(Long actId, List<Long> ids);
}
