package cn.com.duiba.activity.center.api.remoteservice.quizz;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzOptionsDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

/**
 * Created by xuezhaoming on 16/6/15.
 */
@AdvancedFeignClient
public interface RemoteDuibaQuizzOptionsService {

    /**
     * 
     * findOptionsByQuizzId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaQuizzId
     * @return
     * @since JDK 1.6
     */
    List<DuibaQuizzOptionsDto> findOptionsByQuizzId(Long duibaQuizzId);

    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    DuibaQuizzOptionsDto find(Long id);


    //from mangaer and develop
    /**
     * 
     * findByQuizzId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param quizzId
     * @return
     * @since JDK 1.6
     */
    List<DuibaQuizzOptionsDto> findByQuizzId(Long quizzId);
    /**
     * 
     * findByQuizzIds:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param quizzIds
     * @return
     * @since JDK 1.6
     */
    public Map<Long, List<DuibaQuizzOptionsDto>> findByQuizzIds(List<Long> quizzIds);

    /**
     * 
     * delete:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param ids
     * @return
     * @since JDK 1.6
     */
    int delete(List<Long> ids);

    /**
     * 
     * insert:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param quizzOptionsDO
     * @return
     * @since JDK 1.6
     */
    DuibaQuizzOptionsDto insert(DuibaQuizzOptionsDto quizzOptionsDO);

    /**
     * 
     * updateInfoForm:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param quizzOptionsDO
     * @return
     * @since JDK 1.6
     */
    int updateInfoForm(DuibaQuizzOptionsDto quizzOptionsDO);

    /**
     * 
     * updateRemainingById:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @param remaining
     * @return
     * @since JDK 1.6
     */
    int updateRemainingById(Long id, Integer remaining);
}
