package cn.com.duiba.activity.center.api.dto.pyramid_spread;

import cn.com.duiba.activity.center.api.enums.pyramid_spread.PyramidSpreadNewRewardTypeEnum;
import cn.com.duiba.activity.center.api.enums.pyramid_spread.PyramidSpreadPlayTypeEnum;
import cn.com.duiba.activity.center.api.enums.pyramid_spread.SpreadConsumerActStatusEnum;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by HePeng on 2019/04/25 11:44.
 */
public class SpreadConsumerIndexDataDto implements Serializable {
    private static final long serialVersionUID = -8490917878523840747L;

    /**
     * 玩法类型
     */
    private PyramidSpreadPlayTypeEnum playTypeEnum;

    /**
     * 活动标题
     */
    private String title;

    /**
     * 活动规则
     */
    private String rule;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 新人奖励类型
     */
    private PyramidSpreadNewRewardTypeEnum newRewardTypeEnum;

    /**
     * 新人奖励固定数值（单位：分）
     */
    private Long newRewardFixed;

    /**
     * 新人奖励随机区间区间列表
     */
    private List<NewRewardRegion> newRewardRegionList;

    /**
     * 邀请奖励数值（单位：分）
     */
    private Long inviteReward;

    /**
     * 最多可邀请人数
     */
    private Integer maxInvite;

    /**
     * 二级抽成比率
     */
    private Integer levelTwoRate;

    /**
     * 三级抽成比率
     */
    private Integer levelThreeRate;

    /**
     * 分享标题
     */
    private String shareTitle;

    /**
     * 分享副标题
     */
    private String shareSubTitle;

    /**
     * 分享图片链接
     */
    private String sharePic;

    /**
     * 分享应用名称
     */
    private String shareAppName;

    /**
     * 活动状态
     */
    private SpreadConsumerActStatusEnum statusEnum;

    /**
     * 用户总收益（单位：分）
     */
    private Long totalIncome;

    /**
     * 用户是否为新用户
     */
    private Boolean newUserFlag;

    /**
     * 待领取邀请红包数
     */
    private Integer toReapInviteBonusCount;

    /**
     * 待领取邀请红包金额（单位：分）
     */
    private Long toReapInviteBonusAmount;

    /**
     * 待领取邀请红包列表
     */
    private List<SpreadConsumerBonusDto> toReapInviteBonusList;

    /**
     * 已领取邀请红包数
     */
    private Integer reapedInviteBonusCount;

    public PyramidSpreadPlayTypeEnum getPlayTypeEnum() {
        return playTypeEnum;
    }

    public void setPlayTypeEnum(PyramidSpreadPlayTypeEnum playTypeEnum) {
        this.playTypeEnum = playTypeEnum;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public PyramidSpreadNewRewardTypeEnum getNewRewardTypeEnum() {
        return newRewardTypeEnum;
    }

    public void setNewRewardTypeEnum(PyramidSpreadNewRewardTypeEnum newRewardTypeEnum) {
        this.newRewardTypeEnum = newRewardTypeEnum;
    }

    public Long getNewRewardFixed() {
        return newRewardFixed;
    }

    public void setNewRewardFixed(Long newRewardFixed) {
        this.newRewardFixed = newRewardFixed;
    }

    public List<NewRewardRegion> getNewRewardRegionList() {
        return newRewardRegionList;
    }

    public void setNewRewardRegionList(List<NewRewardRegion> newRewardRegionList) {
        this.newRewardRegionList = newRewardRegionList;
    }

    public Long getInviteReward() {
        return inviteReward;
    }

    public void setInviteReward(Long inviteReward) {
        this.inviteReward = inviteReward;
    }

    public Integer getMaxInvite() {
        return maxInvite;
    }

    public void setMaxInvite(Integer maxInvite) {
        this.maxInvite = maxInvite;
    }

    public Integer getLevelTwoRate() {
        return levelTwoRate;
    }

    public void setLevelTwoRate(Integer levelTwoRate) {
        this.levelTwoRate = levelTwoRate;
    }

    public Integer getLevelThreeRate() {
        return levelThreeRate;
    }

    public void setLevelThreeRate(Integer levelThreeRate) {
        this.levelThreeRate = levelThreeRate;
    }

    public String getShareTitle() {
        return shareTitle;
    }

    public void setShareTitle(String shareTitle) {
        this.shareTitle = shareTitle;
    }

    public String getShareSubTitle() {
        return shareSubTitle;
    }

    public void setShareSubTitle(String shareSubTitle) {
        this.shareSubTitle = shareSubTitle;
    }

    public String getSharePic() {
        return sharePic;
    }

    public void setSharePic(String sharePic) {
        this.sharePic = sharePic;
    }

    public String getShareAppName() {
        return shareAppName;
    }

    public void setShareAppName(String shareAppName) {
        this.shareAppName = shareAppName;
    }

    public SpreadConsumerActStatusEnum getStatusEnum() {
        return statusEnum;
    }

    public void setStatusEnum(SpreadConsumerActStatusEnum statusEnum) {
        this.statusEnum = statusEnum;
    }

    public Long getTotalIncome() {
        return totalIncome;
    }

    public void setTotalIncome(Long totalIncome) {
        this.totalIncome = totalIncome;
    }

    public Boolean getNewUserFlag() {
        return newUserFlag;
    }

    public void setNewUserFlag(Boolean newUserFlag) {
        this.newUserFlag = newUserFlag;
    }

    public Integer getToReapInviteBonusCount() {
        return toReapInviteBonusCount;
    }

    public void setToReapInviteBonusCount(Integer toReapInviteBonusCount) {
        this.toReapInviteBonusCount = toReapInviteBonusCount;
    }

    public Long getToReapInviteBonusAmount() {
        return toReapInviteBonusAmount;
    }

    public void setToReapInviteBonusAmount(Long toReapInviteBonusAmount) {
        this.toReapInviteBonusAmount = toReapInviteBonusAmount;
    }

    public List<SpreadConsumerBonusDto> getToReapInviteBonusList() {
        return toReapInviteBonusList;
    }

    public void setToReapInviteBonusList(List<SpreadConsumerBonusDto> toReapInviteBonusList) {
        this.toReapInviteBonusList = toReapInviteBonusList;
    }

    public Integer getReapedInviteBonusCount() {
        return reapedInviteBonusCount;
    }

    public void setReapedInviteBonusCount(Integer reapedInviteBonusCount) {
        this.reapedInviteBonusCount = reapedInviteBonusCount;
    }
}
