package cn.com.duiba.activity.center.api.enums;


import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @Desc pk赛活动中 用于限制题目是瓜分积分，还是瓜分红包的配置标志
 * @author liukai
 * @date 2018/05/03
 */
public enum BetActivityBonusTypeNum {
    POCKET(1, "瓜分红包"),
    EXP(2, "瓜分积分"),
    EXP_POCKET(3, "瓜分积分&瓜分红包");

    private Integer code;
    private String desc;

    public static final ImmutableMap<Integer, BetActivityBonusTypeNum> BetActivityBonusType_MAP;

    static {
        Map<Integer, BetActivityBonusTypeNum> temp = Maps.newHashMap();
        for (BetActivityBonusTypeNum betActivityBonusTypeNum : values()) {
            temp.put(betActivityBonusTypeNum.getCode(), betActivityBonusTypeNum);
        }
        BetActivityBonusType_MAP = ImmutableMap.copyOf(temp);
    }

    BetActivityBonusTypeNum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    public static BetActivityBonusTypeNum getBetActivityBonusTypeNum(Integer code) {
        if(BetActivityBonusType_MAP.containsKey(code)){
            return BetActivityBonusType_MAP.get(code);
        }else{
            return null;
        }
    }


}
