/**
 * Project Name:activity-center-api
 * File Name:RemoteActivityCategoryBackendService.java
 * Package Name:cn.com.duiba.activity.center.api.remoteservice
 * Date:2016年6月7日上午8:52:18
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.remoteservice;

import cn.com.duiba.activity.center.api.dto.ActivityCategoryDto;
import cn.com.duiba.activity.center.api.dto.CategoryActivityDto;
import cn.com.duiba.activity.center.api.params.CategoryFloorParams;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * ClassName:RemoteActivityCategoryBackendService <br/>
 * Function: 活动类目管理的前台接口 <br/>
 * Date:     2016年6月7日 上午8:52:18 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteActivityCategoryService {

    /**
     * 查询所有的活动分类
     *
     * @author xuhengfei
     * @return
     * @param id
     * @since JDK 1.6
     */
    DubboResult<ActivityCategoryDto> findById(long id);

    /**
     * 加载子页面楼层数据
     * @param params
     * @return
     */
    DubboResult<List<CategoryActivityDto>> findAppFloorCategory(CategoryFloorParams params);

    /**
     * 
     * findAllActivitiesByAppCategory:查询App下某个分类的所有活动列表. <br/>
     * 
     * 开发者子页面展示活动用，要求此活动兑吧与开发者均处于开启状态.<br/>
     * 当operating_activity表中的状态被置为关闭时，删除关系表数据，当置为开启时，新增关系表数据.<br/>
     * 开启需要考虑的点：计划任务推送，人为点击开启
     * 关闭需要考虑的点：管理员关闭活动，人为点击关闭
     * 
     * @author wubo
     * @param appId 应用id
     * @param categoryId 活动类目id
     * @param start
     * @param pageSize
     * @return CategoryActivityDto
     * @since JDK 1.6
     */
    DubboResult<List<CategoryActivityDto>> findAllActivitiesByAppCategory(long appId,long categoryId,int start,int pageSize);
    
    /**
     * 
     * findAllActivitiesByAppCategoryNew:(这里用一句话描述这个方法的作用). <br/>
     * 包括活动的图片信息等
     * 此接口与RemoteAppShowcaseContentService.fillCategoryActivityDtoListNew 结合
     * @author wubo
     * @param appId
     * @param categoryId
     * @param start
     * @param pageSize
     * @param consumerId
     * @param ip
     * @param os
     * @param clickUlr
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<CategoryActivityDto>> findAllActivitiesByAppCategoryNew(long appId,long categoryId,long consumerId, String ip, String os,
                                                                             String clickUlr,int start,int pageSize);

    /**
     * 废弃原因:将此判断逻辑从WEB端下沉到活动中心,减少dubbo调用
     * @deprecated isCategoryEnable
     * 判断子页面是否可以在app中展示
     * 1. 子页面没有被删除
     * 2. 子页面没有开启定向,或子页面开启定向且app在定向白名单中
     *
     * @author zhanglihui
     * @param appId      应用id
     * @param categoryId 子页面id
     * @return
     * @since JDK 1.6
     */
    @Deprecated
    DubboResult<Boolean> isCategoryEnable(Long appId, Long categoryId);
}
