package cn.com.duiba.activity.center.api.remoteservice.guessredpacket;

import cn.com.duiba.activity.center.api.dto.guessredpacket.NewGuessRedPacketInfoDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2019/3/27 11:07
 */
@AdvancedFeignClient
public interface RemoteGuessRedPacketInfoService {

    /**
     * 获取用户拆红包记录
     *
     * @param appId      应用ID
     * @param activityId 活动ID
     * @param consumerId 用户ID
     * @return
     */
    List<NewGuessRedPacketInfoDto> getConsumerPacket(Long appId, Long activityId, Long consumerId);

    /**
     * 获取最近猜成功的记录，20条
     * 该接口无缓存，调用方自己加
     *
     * @param appId
     * @param activityId
     * @return
     */
    List<NewGuessRedPacketInfoDto> getLatestSuccessPacket(Long appId, Long activityId);

    /**
     * 插入记录
     *
     * @param dto
     * @return
     */
    Long insert(NewGuessRedPacketInfoDto dto);

    /**
     * 更新红包状态
     *
     * @param dto
     * @return
     */
    Boolean updateRedPacket(NewGuessRedPacketInfoDto dto);
}
