package cn.com.duiba.activity.center.api.remoteservice.miningmachine;

import cn.com.duiba.activity.center.api.dto.miningmachine.CreditsQueryAnswerDto;
import cn.com.duiba.activity.center.api.dto.miningmachine.MingStartResultDto;
import cn.com.duiba.activity.center.api.dto.miningmachine.MiningMachineDto;
import cn.com.duiba.activity.center.api.dto.miningmachine.PkFriendsResultDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @program: activity-all
 * @description: 挖矿机业务处理类
 * @author: Simba
 * @create: 2019-05-13 09:51
 **/
@AdvancedFeignClient
public interface RemoteMiningMachineBusinessService {

    /**
     * 计算开始挖矿结果
     *
     * @param opActivityId
     * @param consumerId
     * @param unitName
     * @param miningMachineDto
     * @return
     */
    MingStartResultDto miningStartResult(Long opActivityId, Long consumerId, String unitName, MiningMachineDto miningMachineDto);

    /**
     * 发起PK结果
     *
     * @param opActivityId
     * @param consumerId
     * @param unitName
     * @param miningMachineDto
     * @return
     */
    PkFriendsResultDto pkFriendsResult(Long opActivityId, Long consumerId, String unitName, MiningMachineDto miningMachineDto);

    /**
     * 获取轮播弹幕
     *
     * @param opActivityId
     * @return
     */
    List<String> obtainBarrage(Long opActivityId, Long appId);

    /**
     * 查询活动子订单积分 减扣/增加 结果
     *
     * @param operationType
     * @param actOrderNum
     * @return
     */
    CreditsQueryAnswerDto queryCreditsAnswer(Integer operationType, String actOrderNum, Long consumerId) throws BizException;
}

