package cn.com.duiba.activity.center.api.remoteservice.miningmachine;

import cn.com.duiba.activity.center.api.dto.miningmachine.MiningMachineDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;


/**
 * @program: activity-all
 * @description: 挖矿机活动配置接口
 * @author: Simba
 * @create: 2019-04-29 16:04
 **/
@AdvancedFeignClient
public interface RemoteMiningMachineService {

    /**
     * 新增挖矿机活动配置
     * 会同步创建入库活动
     * 根据参数决定活动是否开启
     * 2; //开启
     * 3; //关闭
     * 返回 挖矿机活动id
     *
     * @param dto
     * @return
     */
    MiningMachineDto insert(MiningMachineDto dto, Integer statusInt);

    /**
     * 修改挖矿机活动配置
     * 会同步更新入库活动
     * statusInt：
     *      2; //开启
     *      3; //关闭
     *      空则不更新活动开关状态
     * 返回 挖矿机活动id
     *
     * @param dto
     * @param statusInt
     * @return
     */
    int update(MiningMachineDto dto, Integer statusInt);

    /**
     * 根据挖矿机活动id查询活动配置
     *
     * @param id
     * @return
     */
    MiningMachineDto findById(Long id);

    /**
     * 根据入库活动id 查询活动配置
     *
     * @param operatingActivityId
     * @return
     */
    MiningMachineDto findByOperatingActivityId(Long operatingActivityId);

    /**
     * 会同步删除入库活动
     * 只要删除成功 就会返回true
     *
     * @param id
     * @return
     */
    int deleteById(Long id);

}

