package cn.com.duiba.activity.center.api.enums;

/**
 * 幸运码奖品类型枚举
 * author zhanghuifeng
 * date 2019-03-20-16:18
 */
public enum LuckyCodeAwardTypeEnum {

    COUPON(1, "优惠券"),
    VIRTUAL_ITEM(2, "未领奖"),
    OBJECT_ITEM(3, "实物"),

    ;


    private Integer code;
    private String desc;

    LuckyCodeAwardTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static LuckyCodeAwardTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (LuckyCodeAwardTypeEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
