package cn.com.duiba.activity.center.api.remoteservice.equity;

import cn.com.duiba.activity.center.api.dto.equity.EquityBatchConfigDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @program: activity-all
 * @description: 权益批次
 * @author: Simba
 * @create: 2019-07-08 11:43
 **/
@AdvancedFeignClient
public interface RemoteEquityBatchConfigService {

    Long save(EquityBatchConfigDto dto);

    int deleteById(Long id);

    int deleteByEquityId(Long equityId);

    int updateById(EquityBatchConfigDto dto);

    EquityBatchConfigDto selectById(Long id);

    List<EquityBatchConfigDto> listByIds(List<Long> ids);

    List<EquityBatchConfigDto> listByEquityId(Long equityId);
}

