package cn.com.duiba.activity.center.api.remoteservice.ngame;


import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameOptionsDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

/**
 * 
 * ClassName: RemoteDuibaNgameOptionsService <br/>
 * date: 2016年12月1日 下午3:51:11 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteDuibaNgameOptionsService {
    /**
     * 
     * findByGameId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaNgameId
     * @return
     * @since JDK 1.6
     */
    List<DuibaNgameOptionsDto> findByGameId(Long duibaNgameId);
    /**
     * 
     * findByGameIds:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaNgameIds
     * @return
     * @since JDK 1.6
     */
	Map<Long, List<DuibaNgameOptionsDto>> findByGameIds(List<Long> duibaNgameIds);

	/**
	 * 
	 * addBatch:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param list
	 * @since JDK 1.6
	 */
	void addBatch(List<DuibaNgameOptionsDto> list);

	/**
	 * 
	 * add:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param duibaNgameOptionsDto
	 * @return
	 * @since JDK 1.6
	 */
	DuibaNgameOptionsDto add(DuibaNgameOptionsDto duibaNgameOptionsDto);

	/**
	 * 
	 * delete:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @since JDK 1.6
	 */
	void delete(Long id);

	/**
	 * 
	 * update:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param duibaNgameOptionsDto
	 * @since JDK 1.6
	 */
	void update(DuibaNgameOptionsDto duibaNgameOptionsDto);

	/**
	 * 
	 * countBigPrizeByGameId:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param duibaNgameId
	 * @return
	 * @since JDK 1.6
	 */
	Integer countBigPrizeByGameId(Long duibaNgameId);

	/**
	 * 
	 * find:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaNgameOptionsDto find(Long id);
	
	/**
	 * 
	 * findByAutoOpen:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param ngameId
	 * @param autoOpen
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaNgameOptionsDto> findByAutoOpen(Long ngameId, boolean autoOpen);
	
	/**
	 * 
	 * findByAutoOpenDesc:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param ngameId
	 * @param autoOpen
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaNgameOptionsDto> findByAutoOpenDesc(Long ngameId, boolean autoOpen);
	
	/**
	 * 
	 * findDisplayOption:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param ngameId
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaNgameOptionsDto> findDisplayOption(Long ngameId);

}
