package cn.com.duiba.activity.center.api.remoteservice.haggle;

import cn.com.duiba.activity.center.api.dto.haggle.HaggleConfigAndPrizeDto;
import cn.com.duiba.activity.center.api.dto.haggle.HaggleConfigDto;
import cn.com.duiba.activity.center.api.dto.haggle.HaggleHelpRecordDto;
import cn.com.duiba.activity.center.api.dto.haggle.HaggleOpenRecordDto;
import cn.com.duiba.activity.center.api.dto.haggle.HagglePrizeDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Author: lufeng
 * @Description: 砍价活动接口
 * @Date: Created in 2019/9/23
 */
@AdvancedFeignClient
public interface RemoteHaggleService {

    /**
     * 新建活动配置
     * @param dto
     * @return
     */
    Long insertConfig(HaggleConfigDto dto);

    /**
     * 新建活动配置（含奖品信息）
     * @param dto
     * @return
     */
    Long insertConfigAndPrizes(HaggleConfigAndPrizeDto dto);

    /**
     * 删除活动配置
     * @param id
     * @return
     */
    boolean deleteConfig(Long id);

    /**
     * 修改活动配置
     * @param dto
     * @return
     */
    Boolean updateConfig(HaggleConfigDto dto);

    /**
     * 修改活动配置（含奖品信息）
     * @param dto
     * @return
     */
    Boolean updateConfigAndPrizes(HaggleConfigAndPrizeDto dto);

    /**
     * 获取活动配置
     * @param id 活动主键id
     * @return
     */
    HaggleConfigDto getConfig(Long id);

    /**
     * 获取活动配置（含奖品信息）
     * @param id 活动主键id
     * @return
     */
    HaggleConfigAndPrizeDto getConfigAndPrizes(Long id);

    /**
     * 获取活动奖品
     * @param configId 活动主键id
     * @return
     */
    List<HagglePrizeDto> listPrizeByConfigId(Long configId);

    /**
     * 获取活动奖品
     * @param id 活动奖品表主键id
     * @return
     */
    HagglePrizeDto getPrizeById(Long id);

    /**
     * 批量插入奖品信息
     * @param list
     * @return
     */
    boolean batchInsertPrizes(List<HagglePrizeDto> list);

    /**
     * 通过活动配置id删除奖品信息
     * @param configId
     * @return
     */
    boolean deletePrizeByConfigId(Long configId);

    /**
     * 插入开砍记录
     * @param dto
     * @return
     */
    Long insertOpenRecord(HaggleOpenRecordDto dto);

    /**
     * 修改开砍记录
     * @param dto
     * @return
     */
    boolean updateOpenRecord(HaggleOpenRecordDto dto);

    /**
     * 通过开砍表主键id查询开砍记录
     * @param id
     * @return
     */
    HaggleOpenRecordDto getOpenRecordById(Long id);

    /**
     * 通过consuemrId获取用户的开砍记录
     * @param consumerId
     * @return
     */
    List<HaggleOpenRecordDto> listOpenRecordByConsumerId(Long consumerId);


    /**
     * 插入帮砍记录
     * @param dto
     * @return
     */
    Long insertHelpRecord(HaggleHelpRecordDto dto);

    /**
     * 通过帮砍表主见id查询帮砍记录
     * @param id
     * @return
     */
    HaggleHelpRecordDto getHelpRecordById(Long id);

    /**
     * 通过开砍记录id查询所有帮砍记录
     * @param openRecordId
     * @return
     */
    List<HaggleHelpRecordDto> listHelpRecordByOpenRecordId(Long openRecordId);
}
