package cn.com.duiba.activity.center.api.remoteservice;

import cn.com.duiba.activity.center.api.dto.docall.DoCallUserInfoDto;
import cn.com.duiba.activity.center.api.params.BatchDoCallUserActionParam;
import cn.com.duiba.activity.center.api.params.DoCallBaseQueryParam;
import cn.com.duiba.activity.center.api.params.DoCallUserActionParam;
import cn.com.duiba.activity.center.api.params.DoCallUserInfoParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 爱奇艺热血街舞定制接口
 * Created by sty on 3/10/18.
 */
@AdvancedFeignClient
public interface RemoteDoCallService {
    /**
     * 根据用户信息查询，如果没有用户信息会新建一条
     * @return
     */
    DoCallUserInfoDto findByConsumer(DoCallUserInfoParam doCallUserInfoParam);

    /**
     * 用户进行da call行为记录流水并且更新用户表
     * @param param
     * @return
     */
    boolean updateConsumerAction(DoCallUserActionParam param);

    /**
     * 批量处理app回调，返回成功的订单编号
     * @param params
     * @return
     */
    List<String> batchUpdateConsumerAction(List<BatchDoCallUserActionParam> params, DoCallBaseQueryParam baseQueryParam);
}
