package cn.com.duiba.activity.center.api.remoteservice.activity;

import cn.com.duiba.activity.center.api.dto.ActivityDto;
import cn.com.duiba.activity.center.api.dto.activity.AdvActivityDto;
import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.dto.recommend.RecommendQueueDto;
import cn.com.duiba.activity.center.api.dto.recommend.RecommendQueueFindDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/6/14.
 */
@AdvancedFeignClient
public interface RemoteOperatingActivityServiceNew {

    /**
     * 
     * findGameByAppIdAndActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param duibaActivityIds
     * @param type
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findGameByAppIdAndActivityId(Long appId, List<Long> duibaActivityIds, Integer type);

    /**
     * 
     * findAllAppTasksContent:(这里用一句话描述这个方法的作用). <br/>
     * 获取能加到计划任务中的app活动
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllAppTasksContent(Long appId);

    /**
     * 获取开启状态的抽奖活动ids
     * @deprecated findOpenLotteryIds
     * 20170119 号 以后该接口下线
     */
    @Deprecated
    @RequestMapping("/findOpenLotteryIdsDeprecated")
    public List<Long> findOpenLotteryIds();

    /**
     * 获取开启状态的抽奖活动ids
     */
    public List<Long> findOpenLotteryIds(Long appId);
    
    /**
     * 
     * findAllOpenDuibaActivity:(这里用一句话描述这个方法的作用). <br/>
     * 获取所有添加了此兑吧专题活动的开启并且非删除状态的开发者活动
     * @param duibaActivityId
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllOpenDuibaActivity(Long duibaActivityId);

    /**
     * @Title: findByAppIdAndDuibaActivityIdAndDeleted
     * @Description: 根据appId和duibaActivityId获取
     * @param appId
     * @param duibaActivityId
     * @param deleted
     * @return
     */
    public OperatingActivityDto findByAppIdAndDuibaActivityIdAndDeleted(Long appId, Long duibaActivityId, Boolean deleted);

    /**
     * 
     * findByAppIdAndDuibaTurntableIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 根据appId和duibaActivityId获取
     * @param appId
     * @param duibaTurntableId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto findByAppIdAndDuibaTurntableIdAndDeleted(Long appId, Long duibaTurntableId, Boolean deleted);

    /**
     * 
     * findByAppIdAndGameConfigDuibaIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 根据appId和gameConfigDuibaId获取
     * @param appId
     * @param gameConfigDuibaId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto findByAppIdAndGameConfigDuibaIdAndDeleted(Long appId, Long gameConfigDuibaId, Boolean deleted);

    /**
     * 
     * findByAppIdAndDuibaSingleLotteryIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 根据appId和duibaSingleLotteryId获取
     * @param appId
     * @param duibaSingleLotteryId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto findByAppIdAndDuibaSingleLotteryIdAndDeleted(Long appId, Long duibaSingleLotteryId, Boolean deleted);

    /**
     * 
     * findByAppIdAndDuibaQuestionAnswerIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 根据appId和duibaQuestionAnswerId获取
     * @param appId
     * @param duibaQuestionAnswerId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto findByAppIdAndDuibaQuestionAnswerIdAndDeleted(Long appId, Long duibaQuestionAnswerId, Boolean deleted);

    /**
     * 
     * findByAppIdAndDuibaSeckillIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 根据appId和duibaSeckillId获取
     * @param appId
     * @param duibaSeckillId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto findByAppIdAndDuibaSeckillIdAndDeleted(Long appId, Long duibaSeckillId, Boolean deleted);

    /**
     * 
     * findByAppIdAndDuibaHdtoolIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 根据appId和duibaHdtoolId获取
     * @param appId
     * @param duibaHdtoolId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto findByAppIdAndDuibaHdtoolIdAndDeleted(Long appId, Long duibaHdtoolId, Boolean deleted);

    /**
     * 
     * findByAppIdAndDuibaQuizzIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 根据appId和duibaQuizzId获取
     * @param appId
     * @param duibaQuizzId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto findByAppIdAndDuibaQuizzIdAndDeleted(Long appId, Long duibaQuizzId, Boolean deleted);

    /**
     * 
     * findByAppIdAndAppSingleLotteryIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 根据appId和AppSingleLotteryId获取
     * @param appId
     * @param appSingleLotteryId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto findByAppIdAndAppSingleLotteryIdAndDeleted(Long appId, Long appSingleLotteryId, Boolean deleted);

    /**
     * 
     * findByAppIdAndAppManualLotteryAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param appManualLotteryId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto findByAppIdAndAppManualLotteryAndDeleted(Long appId, Long appManualLotteryId, Boolean deleted);

    /**
     * 
     * countActivity:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param params
     * @return
     * @since JDK 1.6
     */
    public Long countActivity(Map<String, Object> params);

    /**
     * 
     * findActivityList:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param params
     * @return
     * @since JDK 1.6
     */
    public List<ActivityDto> findActivityList(Map<String, Object> params);


    List<ActivityDto> findActivityListByOperationIds(Map<String, Object> params);

    /**
     * 根据 条件查询活动数量，查询条件同 findActivityListByOperationIds
     * @param params
     * @return
     */
    Integer countActivityByOperationIds(Map<String, Object> params);

    /**
     *
     * findRecommendActivityList:(这里用一句话描述这个方法的作用). <br/>
     * 此方法sql修改后只返回10条新活动工具（除摇一摇）的活动-hww-20170717
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public List<ActivityDto> findRecommendActivityList(Long appId);

    /**
     * 
     * findActivityListByParent:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param params
     * @return
     * @since JDK 1.6
     */
    public List<ActivityDto> findActivityListByParent(Map<String, Object> params);

    /**
     * 
     * deleteTurntable:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param turntableId
     * @param appId
     * @param delete
     * @param status
     * @return
     * @since JDK 1.6
     */
    public Integer deleteTurntable(Long turntableId, Long appId, Boolean delete, Integer status);

    /**
     * 批量删除开发者活动
     * @param appId  应用id
     * @param idList 活动id列表
     * @return 删除条数
     */
    public DubboResult<Integer> deleteActivityBatch(Long appId, List<Long> idList);
    /**
     *
     * findAppIdsByDuibaActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 根据兑吧活动ID 获取所添加的AppId列表 不关心type
     * @param duibaActivityId
     * @return
     * @auther fengjun
     * @since JDK 1.6
     */
    List<Long> findAppIdsByDuibaActivityIdWithoutType(Long duibaActivityId);

    /**
     *
     * findAppIdsByDuibaActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 根据兑吧活动ID 获取所添加的AppId列表
     * @param duibaActivityId
     * @return
     * @since JDK 1.6
     */
    public List<Long> findAppIdsByDuibaActivityId(Long duibaActivityId);

    /**
     * 
     * findAppIdsBySingleLotteryId:(这里用一句话描述这个方法的作用). <br/>
     * 根据单品抽奖ID获取APPID列表
     * @param singleLotteryId
     * @return
     * @since JDK 1.6
     */
    public List<Long> findAppIdsBySingleLotteryId(Long singleLotteryId);

    /**
     * 
     * findAppIdsByActivityIdAndType:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param activityId
     * @param type
     * @return
     * @since JDK 1.6
     */
    public List<Long> findAppIdsByActivityIdAndType(Long activityId, Integer type);

    /**
     * 
     * findAppIdsByDuibaSingleLotteryId:(这里用一句话描述这个方法的作用). <br/>
     * 根据兑吧单品抽奖活动ID 获取所添加的AppId列表
     * @param duibaSingleLotteryId
     * @return
     * @since JDK 1.6
     */
    public List<Long> findAppIdsByDuibaSingleLotteryId(Long duibaSingleLotteryId);

    /**
     * 
     * countAppByActivityIdAndType:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param activityId
     * @param type
     * @return
     * @since JDK 1.6
     */
    public Integer countAppByActivityIdAndType(Long activityId, Integer type);

    /**
     * 
     * findAllByDuibaActivityIds:(这里用一句话描述这个方法的作用). <br/>
     * 根据兑吧活动ids获取List
     * @param daIdList
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllByDuibaActivityIds(List<Long> daIdList);

    /**
     * 
     * findAllByActivityIdsAndType:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param activityIds
     * @param type
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllByActivityIdsAndType(List<Long> activityIds, Integer type);

    /**
     * 
     * findAllByDuibaSingleLotteryIds:(这里用一句话描述这个方法的作用). <br/>
     * 根据兑吧单品抽奖ids获取List
     * @param dslIdList
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllByDuibaSingleLotteryIds(List<Long> dslIdList);

    /**
     * 
     * findIdsByDuibaActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 根据兑吧活动id获取List
     * @param duibaActivityId
     * @return
     * @since JDK 1.6
     */
    public List<Long> findIdsByDuibaActivityId(Long duibaActivityId);

    /**
     * 
     * updateStatusByDuibaActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 关闭所有已经添加该duibaActivity的活动
     * @param status
     * @param duibaActivityId
     * @return
     * @since JDK 1.6
     */
    public int updateStatusByDuibaActivityId(Integer status, Long duibaActivityId);

    /**
     * 
     * updateStatusBySingleLotteryId:(这里用一句话描述这个方法的作用). <br/>
     * 关闭所有已经添加该duibaSingleLottery的活动
     * @param status
     * @param singleLotteryId
     * @return
     * @since JDK 1.6
     */
    public int updateStatusBySingleLotteryId(Integer status, Long singleLotteryId);

    /**
     *
     * updateVisitTimes:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param id
     * @return
     * @since JDK 1.6
     * @deprecated
     */
    public int updateVisitTimes(Long id);

    /**
     * 
     * findIdsBySingleLotteryId:(这里用一句话描述这个方法的作用). <br/>
     * 根据兑吧单品抽奖ID获取开发者活动ids
     * @param duibaSingleLotteryId
     * @return
     * @since JDK 1.6
     */
    public List<Long> findIdsBySingleLotteryId(Long duibaSingleLotteryId);

    /**
     * 
     * findAllByType:(这里用一句话描述这个方法的作用). <br/>
     * 根据类型查询所有
     * @param type
     * @return
     * @deprecated
     * @since JDK 1.6
     */
    @Deprecated
    public List<OperatingActivityDto> findAllByType(Integer type);

    /**
     * 
     * findAllBySingleLotteryId:(这里用一句话描述这个方法的作用). <br/>
     * 根据duibaSingleLotteryId查询
     * @param duibaSingleLotteryId
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllBySingleLotteryId(Long duibaSingleLotteryId);

    /**
     * 
     * findAllBySingleLotteryIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaSingleLotteryId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllBySingleLotteryIdAndDeleted(Long duibaSingleLotteryId, Boolean deleted);

    /**
     * 
     * findAllByDuibaSeckillIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaSeckillId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllByDuibaSeckillIdAndDeleted(Long duibaSeckillId, Boolean deleted);

    /**
     * 
     * findAllByDuibaActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaActivityId
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllByDuibaActivityId(Long duibaActivityId);

    /**
     * 
     * findAllByDuibaSecondsKillId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaSecondsKillId
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllByDuibaSecondsKillId(Long duibaSecondsKillId);

    /**
     * 
     * findAllByDuibaActivityIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaActivityId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllByDuibaActivityIdAndDeleted(Long duibaActivityId, Boolean deleted);

    /**
     * 
     * findAllByDuibaQuestionAnswerIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaQuestionAnswerId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllByDuibaQuestionAnswerIdAndDeleted(Long duibaQuestionAnswerId, Boolean deleted);

    /**
     * 
     * findAllByDuibaQuizzIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaQuizzId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllByDuibaQuizzIdAndDeleted(Long duibaQuizzId, Boolean deleted);

    /**
     * 
     * updateStatusByActivityIdAndType:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param activityId
     * @param type
     * @param status
     * @since JDK 1.6
     */
    public void updateStatusByActivityIdAndType(Long activityId, Integer type, Integer status);

    /**
     * 
     * findByActivityIdAndTypeAndAppIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param activityId
     * @param type
     * @param appId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto findByActivityIdAndTypeAndAppIdAndDeleted(Long activityId, Integer type, Long appId, Boolean deleted);

    /**
     * 
     * findIdsByDuibaActivityIdAndType:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaActivityId
     * @param type
     * @return
     * @since JDK 1.6
     */
    public List<Long> findIdsByDuibaActivityIdAndType(Long duibaActivityId, Integer type);

    /**
     * 
     * findSingleLotteryOperaList:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param activityIds
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findSingleLotteryOperaList(List<Long> activityIds, Long appId);

    /**
     * 
     * findByActivityIdAndParentIdAndTypeAndAppId:(这里用一句话描述这个方法的作用). <br/>
     * 用于查询子活动
     * @param duibaActivityId
     * @param parentActivityId
     * @param type
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto findByActivityIdAndParentIdAndTypeAndAppId(Long duibaActivityId, Long parentActivityId, Integer type, Long appId);

    /**
     * 
     * deleteByParentActivityIds:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param parentIds
     * @since JDK 1.6
     */
    public void deleteByParentActivityIds(List<Long> parentIds);

    /**
     * 
     * findOperatingSingleLottery:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param activityId
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto findOperatingSingleLottery(Long activityId, Long appId);

    /**
     * 
     * findAllByIds:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param ids
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllByIds(List<Long> ids);

    /**
     * 
     * updateManualLotteryByIds:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param ids
     * @return
     * @since JDK 1.6
     */
    public int updateManualLotteryByIds(List<Long> ids);

    /**
     * 
     * findAllEnabledActivies:(这里用一句话描述这个方法的作用). <br/>
     * 查询某个App的所有正在启用状态的运营活动
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllEnabledActivies(Long appId);

    /**
     * 
     * findActiveActivity:(这里用一句话描述这个方法的作用). <br/>
     * 获取开启状态的活动
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findActiveActivity(Long appId);

    /**
     * 
     * findAllVirtualInSingleLottery:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public List<Long> findAllVirtualInSingleLottery(Long appId);

    /**
     * 
     * findAllVirtualInHdTool:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public List<Long> findAllVirtualInHdTool(Long appId);

    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto find(Long id);

    /**
     * 
     * insert:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param operatingActivityDO
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto insert(OperatingActivityDto operatingActivityDO);

    /**
     * 
     * update:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param operatingActivityDO
     * @return
     * @since JDK 1.6
     */
    public int update(OperatingActivityDto operatingActivityDO);

    /**
     * 
     * findAppIdsByDuibaSecondsKillId:(这里用一句话描述这个方法的作用). <br/>
     * 根据兑吧秒杀专题活动ID 获取所添加的AppId列表
     * @param duibaSecondsKillId
     * @return
     * @since JDK 1.6
     */
    public List<Long> findAppIdsByDuibaSecondsKillId(Long duibaSecondsKillId);

    /**
     * 
     * findAllByDuibaSecondsKillActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaSecondsKillActivityId
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllByDuibaSecondsKillActivityId(Long duibaSecondsKillActivityId);

    /**
     * 
     * findAllByDuibaQuestionAnswerId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaQuestionAnswerId
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllByDuibaQuestionAnswerId(Long duibaQuestionAnswerId);

    /**
     * 
     * findAllByDuibaQuizzId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaQuizzId
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllByDuibaQuizzId(Long duibaQuizzId);

    /**
     * 
     * findAllByDuibaSeckillId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaSeckillId
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllByDuibaSeckillId(Long duibaSeckillId);

    /**
     * 
     * findAllByDuibaSecondsKillActivityIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaSecondsKillActivityId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllByDuibaSecondsKillActivityIdAndDeleted(Long duibaSecondsKillActivityId, Boolean deleted);

    /**
     * 
     * updateStatusByDuibaSecondsKillActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param status
     * @param duibaSecondsKillActivityId
     * @since JDK 1.6
     */
    public void updateStatusByDuibaSecondsKillActivityId(Integer status, Long duibaSecondsKillActivityId);

    /**
     * 
     * findGameOperatingActivity:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param gameConfigDuibaId
     * @param gameType
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto findGameOperatingActivity(Long appId, Long gameConfigDuibaId, Integer gameType);

    /**
     * 
     * findQuestionAnswerOperatingActivity:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param activityId
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto findQuestionAnswerOperatingActivity(Long appId, Long activityId);

    /**
     * 
     * findSecondsKillOperatingActivity:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param activityId
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto findSecondsKillOperatingActivity(Long appId, Long activityId);

    /**
     * 
     * findByAppIdAndDuibaGameIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param duibaGameId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto findByAppIdAndDuibaGameIdAndDeleted(Long appId, Long duibaGameId, Boolean deleted);

    /**
     * 
     * findByAppIdLimit:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param activityId
     * @return
     * @since JDK 1.6
     */
    public ActivityDto findByAppIdLimit(Long appId, Long activityId);

    //from developer project
    /**
     * 
     * findAllByAppId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllByAppId(Long appId);

    /**
     * 
     * findByAppIdAndDuibaSecondsKillActivityIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param duibaSecondsKillActivityId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto findByAppIdAndDuibaSecondsKillActivityIdAndDeleted(Long appId, Long duibaSecondsKillActivityId, Boolean deleted);

    /**
     * 
     * findDuibaQuestionAnswerByAppIdAndActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param activityIds
     * @param type
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findDuibaQuestionAnswerByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type);

    /**
     * 
     * findDuibaQuizzByAppIdAndActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param activityIds
     * @param type
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findDuibaQuizzByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type);

    /**
     * 
     * findDuibaSeckillByAppIdAndActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param activityIds
     * @param type
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findDuibaSeckillByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type);

    /**
     * 
     * findOnlineActivity:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param params
     * @return
     * @since JDK 1.6
     */
    public List<ActivityDto> findOnlineActivity(Map<String, Object> params);

    /**
     * 
     * findOnlineActivityWithOutTopic:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param params
     * @return
     * @since JDK 1.6
     */
    public List<ActivityDto> findOnlineActivityWithOutTopic(Map<String, Object> params);

    /**
     * 
     * findAllByDuibaGuessIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaGuessId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllByDuibaGuessIdAndDeleted(Long duibaGuessId, Boolean deleted);
    /**
     * 
     * findAllByPluginIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param pluginId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllByPluginIdAndDeleted(Long pluginId, Boolean deleted);
    /**
     * 
     * findAppIdsByDuibaGuessId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaGuessId
     * @return
     * @since JDK 1.6
     */
    public List<Long> findAppIdsByDuibaGuessId(Long duibaGuessId);
    /**
     * 
     * findAllByDuibaNgameId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaNgameId
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllByDuibaNgameId(Long duibaNgameId);
    /**
     * 
     * findAllByDuibaGuessId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaGuessId
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllByDuibaGuessId(Long duibaGuessId);
    /**
     * 
     * findAllByDuibaPluginId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param pluginId
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findAllByDuibaPluginId(Long pluginId);

    /**
     * 
     * findDuibaNgameByAppIdAndActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param activityIds
     * @param type
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findDuibaNgameByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type);

    /**
     * 
     * findDuibaGuessByAppIdAndActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param activityIds
     * @param type
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityDto> findDuibaGuessByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type);

    /**
     * 
     * findByAppIdAndDuibaGuessIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 根据appId和duibaQuizzId获取
     * @param appId
     * @param duibaGuessId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto findByAppIdAndDuibaGuessIdAndDeleted(Long appId, Long duibaGuessId, Boolean deleted);
    /**
     * 
     * findByAppIdAndDuibaNgameActivityIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param duibaNgameActivityId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto findByAppIdAndDuibaNgameActivityIdAndDeleted(Long appId, Long duibaNgameActivityId, Boolean deleted);
    /**
     * 
     * findByAppIdAndDuibaGuessActivityIdAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param duibaGuessActivityId
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto findByAppIdAndDuibaGuessActivityIdAndDeleted(Long appId, Long duibaGuessActivityId, Boolean deleted);
    
    /**
     * 
     * findByAppIdAndActivityIdAndTypeAndDeleted:(这里用一句话描述这个方法的作用). <br/>
     * 根据appID和游戏ID以及类型 查询实体信息
     * @param appId
     * @param activityId
     * @param activityType
     * @param deleted
     * @return
     * @since JDK 1.6
     */
    OperatingActivityDto findByAppIdAndActivityIdAndTypeAndDeleted(Long appId, Long activityId,int activityType, Boolean deleted);

    /**
     * 
     * findSeckillIdsByActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaSeckillId
     * @return
     * @since JDK 1.6
     */
    List<Long> findSeckillIdsByActivityId(Long duibaSeckillId);
    /**
     * 
     * findAppIdsByIds:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param ids
     * @return
     * @since JDK 1.6
     */
    public List<Long> findAppIdsByIds(List<Long> ids);
    
    /**
     * 
     * insert:添加前，校验appId,activityId,type是否存在. <br/>
     *
     * @author wubo
     * @param operatingActivityDO
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityDto insertUnique(OperatingActivityDto operatingActivityDO);
    
    /**
     * 
     * increaseJoinNum:(这里用一句话描述这个方法的作用). <br/>
     * 增加中奖人数
     * @param operatingActivityId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Boolean> increaseJoinNum(Long operatingActivityId); 
    
    /**
     * 
     * queryAdvActivity:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param operatingActivityId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<AdvActivityDto> queryAdvActivity(Long operatingActivityId);
    
    /**
     * 
     * batchQueryAdvActivty:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param ids
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<AdvActivityDto>> batchQueryAdvActivty(List<Long> ids);
    
    /**
     * 根据兑吧活动ID查询已配置的开发者活动
     * @param activityId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<OperatingActivityDto>> findByActivityId(Long activityId);
    
    /**
     * 根据兑吧活动ID和活动类型查询开发者活动
     * @param activityId
     * @param types
     * @return
     */
    DubboResult<List<OperatingActivityDto>> findByActivityIdAndType(Long activityId, List<Integer> types);
    
    /**
     * 
     * updateByActivityIdAndActivityType:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param activityId
     * @param activityType
     * @param dto
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> updateByActivityIdAndActivityType(Long activityId, Integer activityType,OperatingActivityDto dto);

    /**
     *
     * findRecommendActivityListNew:查询活动推荐位数据       统一访问日志上线后 本方法下线. <br/>
     * @deprecated findRecommendActivityListNew
     * @param appId
     * @param operatingActivityId    当前活动id
     * @param count             要查询多少个 推荐位活动 默认2个
     * @param consumerId
     * @param domain
     * @param ip
     * @param shrarUrl
     * @return
     * @since JDK 1.6
     */
    @Deprecated
    @RequestMapping("/findRecommendActivityListNewDeprecated")
    public List<RecommendQueueDto> findRecommendActivityListNew(Long appId,Long operatingActivityId, Integer count,Long consumerId,String domain,String ip,String shrarUrl);

    /**
     *
     * findRecommendActivityListNew:查询活动推荐位数据       . <br/>
     *
     * @param dto
     * @return
     * @since JDK 1.6
     */
    public List<RecommendQueueDto> findRecommendActivityListNew(RecommendQueueFindDto dto);

    /**
     * 把专题活动中主推到开发者后台的 兑换项/单品 添加到开发者库
     * 
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<Long>> findAllSelfActivityAutoOff();
    
    /**
     * 把专题活动中主推到开发者后台的 兑换项/单品 添加到开发者库
     * 
     * @param ids
     * @return
     * @since JDK 1.6
     */
    void closeAllSelfActivityAutoOff(List<Long> ids);

    /**
     * 把专题活动中主推到开发者后台的 兑换项/单品 从开发者库中删除
     * @param id
     * @since JDK 1.6
     */
    public void deleteDuibaActivityMainPushFromDev(Long id);

    /**
     * 把专题活动中主推到开发者后台的 兑换项/单品 添加到开发者库
     * @param id
     * @since JDK 1.6
     */
    public void addDuibaActivityMainPush2Dev(Long id);

    /**
     * 清除活动过期时间
     * 若本身已过期关闭，则重新变为数据完整状态
     * @return
     */
    DubboResult<Boolean> clearAutoOffDate(OperatingActivityDto operatingActivityDto);

    /**
     * 根据appId获取当前应用所有开启的兑吧活动
     * @return
     */
    List<OperatingActivityDto> findAllAliveDuibaActivityByAppId(Long appId);

    /**
     * 根据传入的ids和活动开启状态来查询
     * @param
     * @return
     */
    List<OperatingActivityDto> findAllByIdsAndStatus(List<Long> ids,int status);

    /**
     * 根据id批量修改开发者库的积分价值
     * @param
     * @return
     */
    void batchUpdateCreditsByList(List<OperatingActivityDto> list);

    /**
     * 根据对象集合获取对象集合
     * @param
     * @return
     */
    List<OperatingActivityDto> listByEntityList(List<OperatingActivityDto> list);

    /**
     * 根据id修改开发者库的积分价值
     * @param
     * @return
     */
    void updateCreditsById(Long id, Long credits);

    /**
     * 根据appId,活动id和类型查询开发者入库活动
     * @param
     * @return
     */
    OperatingActivityDto findByAppIdAndActivityIdAndType(Long appId, Long activityId, Integer type);

    /**
     * pk赛组件和appId绑定
     * @param appId
     * @param type
     * @param delete
     * @return
     */
    OperatingActivityDto findByAppIdAndType(Long appId, Integer type,Boolean delete);
}
