package cn.com.duiba.activity.center.api.remoteservice.quizz;

import java.util.Date;
import java.util.List;

import cn.com.duiba.activity.center.api.dto.quizz.QuizzOrdersDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 
 * ClassName: RemoteQuizzOrdersSimpleService <br/>
 * date: 2016年12月1日 下午5:17:03 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteQuizzOrdersSimpleService {
    /**
     * 
     * countByConsumerIdAndOperatingActivityId:(这里用一句话描述这个方法的作用). <br/>
     * @param consumerId
     * @param operatingActivityId
     * @return
     * @since JDK 1.6
     */
	public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId);

	/**
	 * 
	 * countByConsumerIdAndOperatingActivityIdAndDate:(这里用一句话描述这个方法的作用). <br/>
	 * @param consumerId
	 * @param operatingActivityId
	 * @param start
	 * @param end
	 * @return
	 * @since JDK 1.6
	 */
	public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start,
                                                           Date end);
	/**
	 * 
	 * countFreeByConsumerIdAndOperatingActivityIdAndDate:(这里用一句话描述这个方法的作用). <br/>
	 * @param consumerId
	 * @param id
	 * @param start
	 * @param end
	 * @return
	 * @since JDK 1.6
	 */
	public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long id, Date start, Date end);

	/**
	 * 
	 * countFreeByConsumerIdAndOperatingActivityId:(这里用一句话描述这个方法的作用). <br/>
	 * @param consumerId
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long id);

	/**
	 * 
	 * find:(这里用一句话描述这个方法的作用). <br/>
	 * @param consumerId
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public QuizzOrdersDto find(Long consumerId, Long id);

	/**
	 * 
	 * countByConsumerIdAndPrizeId:(这里用一句话描述这个方法的作用). <br/>
	 * @param consumerId
	 * @param operatingActivityId
	 * @param prizeId
	 * @return
	 * @since JDK 1.6
	 */
	public Integer countByConsumerIdAndPrizeId(Long consumerId, Long operatingActivityId, Long prizeId);

	/**
	 * 
	 * findByIds:(这里用一句话描述这个方法的作用). <br/>
	 * @param consumerId
	 * @param ids
	 * @return
	 * @since JDK 1.6
	 */
	public List<QuizzOrdersDto> findByIds(Long consumerId, List<Long> ids);
	
	/**
	 * 
	 * insert:(这里用一句话描述这个方法的作用). <br/>
	 * @param quizzOrdersDto
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public QuizzOrdersDto insert(QuizzOrdersDto quizzOrdersDto, long id);
}
