package cn.com.duiba.activity.center.api.remoteservice.bet;

import cn.com.duiba.activity.center.api.dto.bet.BetGroupRelationDto;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * @author zhangruofan
 * @date 2018/05/03
 */
@AdvancedFeignClient
public interface RemoteBackendBetGroupRelationService {
    /**
     * 新建投注活动和活动组关系
     * @param betGroupRelationDto 关系参数
     * @return key
     * @throws BizException bizException
     */
    Long insert(BetGroupRelationDto betGroupRelationDto) throws BizException;

    /**
     * 删除关系
     * @param id key
     * @return 成功行数
     * @throws BizException bizException
     */
    Integer delete(Long id) throws BizException;

    /**
     * 批量新增和删除关系
     * @param betId 投注活动id
     * @param groupIds 关联的活动组id
     * @param endTime 结束时间
     * @param configStatus 活动的状态
     * @throws BizException bizException
     */
    void batchUpdate(Long betId, String groupIds, Date endTime, Integer configStatus) throws BizException;

    /**
     * 通过betId分页获取关系列表
     * @param betId 活动组id
     * @param pageNo pageNo
     * @param pageSize pageSize
     * @return Page<BetGroupRelationDto>
     */
    Page<BetGroupRelationDto> listByBetId(Long betId, Integer pageNo, Integer pageSize);

    List<BetGroupRelationDto> listByGroupIdWithCache(Long groupId, Integer pageNo, Integer pageSize);

    List<BetGroupRelationDto> listByValidGroupIdWithCache(Long groupId);

}
