package cn.com.duiba.activity.center.api.remoteservice.diggold;

import cn.com.duiba.activity.center.api.dto.diggold.DigGoldConfigAndPrizesDto;
import cn.com.duiba.activity.center.api.dto.diggold.DigGoldConfigDto;
import cn.com.duiba.activity.center.api.dto.diggold.DigGoldPrizeDto;

import java.util.List;

/**
 * @Author: lufeng
 * @Description: 挖金砖活动接口
 * @Date: Created in 2019/7/1
 */
public interface RemoteDigGoldService {

    /**
     * 新建活动配置
     * @param dto
     * @return
     */
    Long insertConfig(DigGoldConfigDto dto);

    /**
     * 新建活动配置(含奖品信息)
     * @param dto
     * @return
     */
    Long insertConfigAndPrizes(DigGoldConfigAndPrizesDto dto);

    /**
     * 修改活动配置
     * @param dto
     * @return
     */
    Boolean updateConfig(DigGoldConfigDto dto);

    /**
     * 修改活动配置(含奖品信息)
     * @param dto
     * @return
     */
    Boolean updateConfigAndPrizes(DigGoldConfigAndPrizesDto dto);

    /**
     * 获取活动配置（含奖品信息）
     * @param id 活动主键id
     * @return
     */
    DigGoldConfigAndPrizesDto getConfigAndPrizes(Long id);

    /**
     * 批量插入奖品信息
     * @param list
     * @return
     */
    boolean batchInsertPrizes(List<DigGoldPrizeDto> list);

    /**
     * 批量删除奖品信息
     * @param id
     * @return
     */
    boolean batchDeletePrizes(Long id);

}
