package cn.com.duiba.activity.center.api.remoteservice.pyramidspread;

import cn.com.duiba.activity.center.api.dto.pyramidspread.PyramidSpreadConfigDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 师徒体系远程服务
 * Created by HePeng on 2019/04/19 11:29.
 */
@AdvancedFeignClient
public interface RemotePyramidSpreadService {
    /**
     * 保存师徒活动配置（包含新增/修改）
     * @param configDto
     * @return
     */
    Long savePyramidSpreadConfig(PyramidSpreadConfigDto configDto) throws BizException;

    /**
     * 通过配置id获取师徒活动配置
     * @param id
     * @return
     */
    PyramidSpreadConfigDto getPyramidSpreadConfigById(Long id);

    /**
     * 通过活动id获取师徒活动配置
     * @param actId
     * @return
     */
    PyramidSpreadConfigDto getPyramidSpreadConfigByActId(Long actId);
}
